/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf;

import java.io.IOException;
import java.io.InputStream;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class SesameInputAdapter
implements RDFHandler {
    private final Sink<Statement> stSink;
    private final Sink<Namespace> nsSink;
    private final Sink<String> cmtSink;

    public SesameInputAdapter(RDFSink sink) {
        this.stSink = sink.statementSink();
        this.nsSink = sink.namespaceSink();
        this.cmtSink = sink.commentSink();
    }

    public void handleComment(String comment) {
        try {
            this.cmtSink.put((Object)comment);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public void handleNamespace(String prefix, String uri) {
        try {
            this.nsSink.put((Object)new NamespaceImpl(prefix, uri));
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public void handleStatement(Statement st) {
        try {
            this.stSink.put((Object)st);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    public void startRDF() {
    }

    public void endRDF() {
    }

    private void logError(Exception e) {
        System.err.println("Error: " + e);
    }

    public static RDFFormat parse(InputStream is, RDFSink sink, String baseUri, RDFFormat format) throws RippleException {
        RDFParser parser = Rio.createParser((RDFFormat)format);
        parser.setRDFHandler((RDFHandler)new SesameInputAdapter(sink));
        try {
            parser.parse(is, baseUri);
        }
        catch (IOException e) {
            throw new RippleException((Throwable)e);
        }
        catch (RDFParseException e) {
            throw new RippleException((Throwable)e);
        }
        catch (RDFHandlerException e) {
            throw new RippleException((Throwable)e);
        }
        return format;
    }
}

