/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.diff;

import net.fortytwo.flow.Sink;
import net.fortytwo.flow.diff.DiffSink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.flow.rdf.RDFTee;
import net.fortytwo.flow.rdf.diff.RDFDiffSink;
import org.openrdf.model.Namespace;
import org.openrdf.model.Statement;

public class RDFDiffTee
implements RDFDiffSink {
    private final RDFTee adderTee;
    private final RDFTee subtractorTee;
    private final DiffSink<Statement> stSink;
    private final DiffSink<Namespace> nsSink;
    private final DiffSink<String> cmtSink;

    public RDFDiffTee(RDFDiffSink sinkA, RDFDiffSink sinkB) {
        this.adderTee = new RDFTee(sinkA.adderSink(), sinkB.adderSink());
        this.subtractorTee = new RDFTee(sinkA.subtractorSink(), sinkB.subtractorSink());
        this.stSink = new DiffSink<Statement>(){

            public Sink<Statement> getPlus() {
                return RDFDiffTee.this.adderTee.statementSink();
            }

            public Sink<Statement> getMinus() {
                return RDFDiffTee.this.subtractorTee.statementSink();
            }
        };
        this.nsSink = new DiffSink<Namespace>(){

            public Sink<Namespace> getPlus() {
                return RDFDiffTee.this.adderTee.namespaceSink();
            }

            public Sink<Namespace> getMinus() {
                return RDFDiffTee.this.subtractorTee.namespaceSink();
            }
        };
        this.cmtSink = new DiffSink<String>(){

            public Sink<String> getPlus() {
                return RDFDiffTee.this.adderTee.commentSink();
            }

            public Sink<String> getMinus() {
                return RDFDiffTee.this.subtractorTee.commentSink();
            }
        };
    }

    @Override
    public RDFSink adderSink() {
        return this.adderTee;
    }

    @Override
    public RDFSink subtractorSink() {
        return this.subtractorTee;
    }

    @Override
    public DiffSink<Statement> statementSink() {
        return this.stSink;
    }

    @Override
    public DiffSink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    @Override
    public DiffSink<String> commentSink() {
        return this.cmtSink;
    }
}

