/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.ranking;

import net.fortytwo.flow.rdf.ranking.WeightedVectorApproximation;

public abstract class ApproxFairOperation<T, E extends Exception>
implements WeightedVectorApproximation<T, E> {
    protected final WeightedVectorApproximation<T, E>[] operands;
    private int startIndex = 0;

    public ApproxFairOperation(WeightedVectorApproximation<T, E> ... operands) {
        this.operands = operands;
    }

    @Override
    public int compute(int cycles) throws E {
        if (0 == this.operands.length) {
            return 0;
        }
        int remainingCycles = cycles;
        int avgCycles = cycles / this.operands.length;
        for (int i = 1; i < this.operands.length; ++i) {
            int consumed = this.operands[(this.startIndex + i) % this.operands.length].compute(avgCycles);
            remainingCycles -= consumed;
            if (consumed == avgCycles) continue;
            avgCycles = remainingCycles / (this.operands.length - i);
        }
        remainingCycles -= this.operands[this.startIndex].compute(remainingCycles);
        ++this.startIndex;
        return cycles - remainingCycles;
    }
}

