/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow;

import java.util.LinkedList;
import net.fortytwo.flow.Collector;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.Source;
import net.fortytwo.ripple.RippleException;

public class HistorySink<T>
implements Sink<T> {
    private final int capacity;
    private final LinkedList<Collector<T>> history;
    private int len;
    private Collector<T> current;

    public HistorySink(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.history = new LinkedList();
        this.len = 0;
    }

    public void advance() {
        this.current = new Collector();
        this.history.addFirst(this.current);
        ++this.len;
        if (this.len > this.capacity) {
            this.history.removeLast();
        }
    }

    @Override
    public void put(T t) throws RippleException {
        this.current.put(t);
    }

    public Source<T> get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.history.size()) {
            return null;
        }
        return this.history.get(index);
    }
}

