/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.OutputSegment;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class AttributesOutputSegment
implements OutputSegment {
    private int begin;
    private int end;
    private Map map;

    public AttributesOutputSegment(Attributes attributes, boolean convertNamesToLowerCase) {
        this(attributes, attributes.getMap(convertNamesToLowerCase));
    }

    public AttributesOutputSegment(Attributes attributes, Map map) {
        if (map == null || attributes == null) {
            throw new IllegalArgumentException("both arguments must be non-null");
        }
        this.begin = attributes.getBegin();
        this.end = attributes.getEnd();
        this.map = map;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public Map getMap() {
        return this.map;
    }

    public void writeTo(Writer writer) throws IOException {
        Attributes.appendHTML(writer, this.map);
    }

    public long getEstimatedMaximumOutputLength() {
        return (this.end - this.begin) * 2;
    }

    public String toString() {
        return Attributes.generateHTML(this.map);
    }

    public String getDebugInfo() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.getBuffer().append('(').append(this.begin).append(',').append(this.end).append("):");
        try {
            this.output(stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void output(Writer writer) throws IOException {
        this.writeTo(writer);
    }
}

