/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;

public final class EndTag
extends Tag {
    private final EndTagType endTagType;

    EndTag(Source source, int begin, int end, EndTagType endTagType, String name) {
        super(source, begin, end, name);
        this.endTagType = endTagType;
    }

    public Element getElement() {
        StartTag startTag;
        if (this.element != Element.NOT_CACHED) {
            return this.element;
        }
        int pos = this.begin;
        while (pos != 0 && (startTag = this.source.findPreviousStartTag(pos - 1)) != null) {
            Element foundElement = startTag.getElement();
            if (foundElement.getEndTag() == this) {
                return foundElement;
            }
            pos = startTag.begin;
        }
        this.element = null;
        return null;
    }

    public EndTagType getEndTagType() {
        return this.endTagType;
    }

    public TagType getTagType() {
        return this.endTagType;
    }

    public boolean isUnregistered() {
        return this.endTagType == EndTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.toString();
    }

    public static String generateHTML(String tagName) {
        return EndTagType.NORMAL.generateHTML(tagName);
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"/").append(this.name).append("\" ");
        if (this.endTagType != EndTagType.NORMAL) {
            sb.append('(').append(this.endTagType.getDescription()).append(") ");
        }
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    public String regenerateHTML() {
        return this.toString();
    }

    public static boolean isForbidden(String name) {
        return HTMLElements.getEndTagForbiddenElementNames().contains(name.toLowerCase());
    }

    public static boolean isOptional(String name) {
        return HTMLElements.getEndTagOptionalElementNames().contains(name.toLowerCase());
    }

    public static boolean isRequired(String name) {
        return HTMLElements.getEndTagRequiredElementNames().contains(name.toLowerCase());
    }

    static EndTag findPreviousOrNext(Source source, int pos, String searchName, EndTagType endTagType, boolean previous) {
        if (searchName == null) {
            return (EndTag)Tag.findPreviousOrNextTag(source, pos, endTagType, previous);
        }
        if (searchName.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String searchString = endTagType.generateHTML(searchName);
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            while (true) {
                int n = begin = previous ? parseText.lastIndexOf(searchString, begin) : parseText.indexOf(searchString, begin);
                if (begin == -1) {
                    return null;
                }
                EndTag endTag = (EndTag)source.getTagAt(begin);
                if (endTag != null && endTag.getEndTagType() == endTagType) {
                    return endTag;
                }
                if (previous) {
                    if (--begin >= 0) {
                        continue;
                    }
                    break;
                }
                if (++begin >= source.end) break;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static EndTag findPreviousOrNext(Source source, int pos, boolean previous) {
        Tag tag;
        while ((tag = Tag.findPreviousOrNextTag(source, pos, previous)) != null) {
            if (tag instanceof EndTag) {
                return (EndTag)tag;
            }
            pos += previous ? -1 : 1;
        }
        return null;
    }
}

