// Jericho HTML Parser - Java based library for analysing and manipulating HTML
// Version 2.4
// Copyright (C) 2007 Martin Jericho
// http://jerichohtml.sourceforge.net/
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of either one of the following licences:
//
// 1. The Eclipse Public License (EPL) version 1.0,
// included in this distribution in the file licence-epl-1.0.html
// or available at http://www.eclipse.org/legal/epl-v10.html
//
// 2. The GNU Lesser General Public License (LGPL) version 2.1 or later,
// included in this distribution in the file licence-lgpl-2.1.txt
// or available at http://www.gnu.org/licenses/lgpl.txt
//
// This library is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the individual licence texts for more details.

package au.id.jericho.lib.html;

import java.io.*;
import java.util.*;

/**
 * Signals that overlapping {@linkplain OutputSegment output segments} have been detected in the {@link OutputDocument}.
 * <p>
 * This exception is only thrown when an attempt is made to {@linkplain OutputDocument#writeTo(Writer) generate the output}
 * of the <code>OutputDocument</code>.
 *
 * @see OutputDocument#toString()
 * @see OutputDocument#writeTo(Writer)
 */
public class OverlappingOutputSegmentsException extends RuntimeException {
	private OutputSegment[] overlappingOutputSegments=new OutputSegment[2];

	OverlappingOutputSegmentsException(final OutputSegment outputSegment1, final OutputSegment outputSegment2) {
		super("Overlapping output segments detected in output document:\n"+outputSegment1.getDebugInfo()+'\n'+outputSegment2.getDebugInfo());
		overlappingOutputSegments[0]=outputSegment1;
		overlappingOutputSegments[1]=outputSegment2;
	}

	/**
	 * Returns the two overlapping output segments in an array.
	 * <p>
	 * Only the first two detected overlapping segments are returned,
	 * even if other overlapping segments were added to the {@link OutputDocument}.
	 *
	 * @return the two overlapping output segments in an array.
	 */
	public OutputSegment[] getOverlappingOutputSegments() {
		return overlappingOutputSegments;
	}
}

