/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.AttributesOutputSegment;
import au.id.jericho.lib.html.BlankOutputSegment;
import au.id.jericho.lib.html.CharOutputSegment;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharStreamSourceUtil;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.RemoveOutputSegment;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StringOutputSegment;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList outputSegments = new ArrayList();

    public OutputDocument(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.sourceText = source;
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(Segment segment) {
        this.register(new RemoveOutputSegment(segment));
    }

    public void remove(Collection segments) {
        Iterator i = segments.iterator();
        while (i.hasNext()) {
            this.remove((Segment)i.next());
        }
    }

    public void insert(int pos, CharSequence text) {
        this.register(new StringOutputSegment(pos, pos, text));
    }

    public void replace(Segment segment, CharSequence text) {
        this.replace(segment.getBegin(), segment.getEnd(), text);
    }

    public void replace(int begin, int end, CharSequence text) {
        this.register(new StringOutputSegment(begin, end, text));
    }

    public void replace(int begin, int end, char ch) {
        this.register(new CharOutputSegment(begin, end, ch));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map replace(Attributes attributes, boolean convertNamesToLowerCase) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes, convertNamesToLowerCase);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes, Map map) {
        this.register(new AttributesOutputSegment(attributes, map));
    }

    public void replaceWithSpaces(int begin, int end) {
        this.register(new BlankOutputSegment(begin, end));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        try {
            if (this.outputSegments.isEmpty()) {
                Util.appendTo(writer, this.sourceText);
                return;
            }
            int pos = 0;
            Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
            OutputSegment lastOutputSegment = null;
            Iterator i = ((AbstractList)this.outputSegments).iterator();
            while (i.hasNext()) {
                OutputSegment outputSegment = (OutputSegment)i.next();
                if (outputSegment == lastOutputSegment) continue;
                if (outputSegment.getBegin() > pos) {
                    Util.appendTo(writer, this.sourceText, pos, outputSegment.getBegin());
                }
                if (outputSegment.getBegin() < pos && outputSegment instanceof BlankOutputSegment) {
                    int outputSegmentEnd = outputSegment.getEnd();
                    while (pos < outputSegmentEnd) {
                        writer.write(32);
                        ++pos;
                    }
                } else {
                    outputSegment.writeTo(writer);
                    if (pos < outputSegment.getEnd()) {
                        pos = outputSegment.getEnd();
                    }
                }
                lastOutputSegment = outputSegment;
            }
            if (pos < this.sourceText.length()) {
                Util.appendTo(writer, this.sourceText, pos, this.sourceText.length());
            }
        }
        finally {
            writer.flush();
        }
    }

    public long getEstimatedMaximumOutputLength() {
        long estimatedMaximumOutputLength = this.sourceText.length();
        Iterator i = ((AbstractList)this.outputSegments).iterator();
        while (i.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)i.next();
            int outputSegmentOriginalLength = outputSegment.getEnd() - outputSegment.getBegin();
            estimatedMaximumOutputLength += outputSegment.getEstimatedMaximumOutputLength() - (long)outputSegmentOriginalLength;
        }
        return estimatedMaximumOutputLength;
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getRegisteredOutputSegments().iterator();
        while (i.hasNext()) {
            OutputSegment outputSegment = (OutputSegment)i.next();
            if (outputSegment instanceof BlankOutputSegment) {
                sb.append("Replace with Spaces: ");
            } else if (outputSegment instanceof RemoveOutputSegment) {
                sb.append("Remove: ");
            } else {
                sb.append("Replace: ");
            }
            if (this.sourceText instanceof Source) {
                Source source = (Source)this.sourceText;
                sb.append('(');
                source.getRowColumnVector(outputSegment.getBegin()).appendTo(sb);
                sb.append('-');
                source.getRowColumnVector(outputSegment.getEnd()).appendTo(sb);
                sb.append(')');
            } else {
                sb.append("(p").append(outputSegment.getBegin()).append("-p").append(outputSegment.getEnd()).append(')');
            }
            sb.append(' ');
            String outputFromSegment = ((Object)outputSegment).toString();
            if (outputFromSegment.length() <= 20) {
                sb.append(outputFromSegment);
            } else {
                sb.append(outputFromSegment.substring(0, 20)).append("...");
            }
            sb.append(Config.NewLine);
        }
        return sb.toString();
    }

    public List getRegisteredOutputSegments() {
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        return this.outputSegments;
    }
}

