/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = true;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean convertNonBreakingSpaces) {
        this.convertNonBreakingSpaces = convertNonBreakingSpaces;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public TextExtractor setExcludeNonHTMLElements(boolean excludeNonHTMLElements) {
        this.excludeNonHTMLElements = excludeNonHTMLElements;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean convertNonBreakingSpaces, boolean includeAttributes, boolean excludeNonHTMLElements) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = convertNonBreakingSpaces;
            this.includeAttributes = includeAttributes;
            this.excludeNonHTMLElements = excludeNonHTMLElements;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.segment.length());
            int textBegin = this.segment.begin;
            Iterator i = this.segment.findAllTags().iterator();
            while (i.hasNext()) {
                Tag tag = (Tag)i.next();
                int textEnd = tag.begin;
                if (textEnd < textBegin) continue;
                while (textBegin < textEnd) {
                    sb.append(this.source.charAt(textBegin++));
                }
                if (tag.getTagType() == StartTagType.NORMAL) {
                    StartTag startTag = (StartTag)tag;
                    if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                        textBegin = startTag.getElement().end;
                        continue;
                    }
                    if (this.includeAttributes) {
                        Attribute contentAttribute;
                        Attribute summaryAttribute;
                        Attribute labelAttribute;
                        Attribute altAttribute;
                        Attributes attributes = startTag.getAttributes();
                        Attribute titleAttribute = attributes.get("title");
                        if (titleAttribute != null) {
                            sb.append(' ').append((Object)titleAttribute.getValueSegment()).append(' ');
                        }
                        if ((altAttribute = attributes.get("alt")) != null) {
                            sb.append(' ').append((Object)altAttribute.getValueSegment()).append(' ');
                        }
                        if ((labelAttribute = attributes.get("label")) != null) {
                            sb.append(' ').append((Object)labelAttribute.getValueSegment()).append(' ');
                        }
                        if ((summaryAttribute = attributes.get("summary")) != null) {
                            sb.append(' ').append((Object)summaryAttribute.getValueSegment()).append(' ');
                        }
                        if ((contentAttribute = attributes.get("content")) != null && attributes.get("name") != null) {
                            sb.append(' ').append((Object)contentAttribute.getValueSegment()).append(' ');
                        }
                    }
                }
                if (tag.getName() == "br" || !HTMLElements.getInlineLevelElementNames().contains(tag.getName())) {
                    sb.append(' ');
                }
                textBegin = tag.end;
            }
            while (textBegin < this.segment.end) {
                sb.append(this.source.charAt(textBegin++));
            }
            String decodedText = CharacterReference.decodeCollapseWhiteSpace(sb, this.convertNonBreakingSpaces);
            return decodedText;
        }
    }
}

