/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.FormControl;
import au.id.jericho.lib.html.HTMLElementTerminatingTagNameSets;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;

public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;

    StartTag(Source source, int begin, int end, StartTagType startTagType, String name, Attributes attributes) {
        super(source, begin, end, name);
        this.attributes = attributes;
        this.startTagType = startTagType;
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.findEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.logger.isInfoEnabled() && !this.element.equals(endTag.element)) {
                    this.source.logger.info(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuffer(200).append("End tag ").append((Object)endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attributeName) {
        return this.attributes == null ? null : this.attributes.getValue(attributeName);
    }

    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int maxErrorCount) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int maxEnd = this.end - this.startTagType.getClosingDelimiter().length();
        int attributesBegin = this.begin + 1 + this.name.length();
        while (!Tag.isXMLNameStartChar(this.source.charAt(attributesBegin))) {
            if (++attributesBegin != maxEnd) continue;
            return null;
        }
        return Attributes.construct(this.source, this.begin, attributesBegin, maxEnd, this.startTagType, this.name, maxErrorCount);
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean toXHTML) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<');
        if (toXHTML && this.startTagType == StartTagType.NORMAL) {
            sb.append(this.name);
        } else {
            int i;
            int nameSegmentEnd = i + this.name.length();
            for (i = this.begin + this.startTagType.startDelimiterPrefix.length(); i < nameSegmentEnd; ++i) {
                sb.append(this.source.charAt(i));
            }
        }
        this.attributes.appendTidy(sb, this.findNextTag());
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            sb.append(" /");
        }
        sb.append(this.startTagType.getClosingDelimiter());
        return sb.toString();
    }

    public static String generateHTML(String tagName, Map attributesMap, boolean emptyElementTag) {
        StringWriter stringWriter = new StringWriter();
        StringBuffer sb = stringWriter.getBuffer();
        sb.append('<').append(tagName);
        try {
            Attributes.appendHTML(stringWriter, attributesMap);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (emptyElementTag) {
            sb.append(" />");
        } else {
            sb.append('>');
        }
        return sb.toString();
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        this.appendDebugTag(sb);
        sb.append(' ');
        this.appendDebugTagType(sb);
        sb.append(super.getDebugInfo());
        return sb.toString();
    }

    StringBuffer appendDebugTag(StringBuffer sb) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            sb.append((Object)this);
        } else {
            sb.append('<').append((Object)this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                sb.append('/');
            }
            sb.append(this.startTagType.getClosingDelimiter());
        }
        return sb;
    }

    StringBuffer appendDebugTagType(StringBuffer sb) {
        if (this.startTagType != StartTagType.NORMAL) {
            sb.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return sb;
    }

    private EndTag findEndTagInternal() {
        EndTag nextEndTag;
        boolean checkForEmptyElementTag = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            HTMLElementTerminatingTagNameSets terminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(this.name);
            if (terminatingTagNameSets != null) {
                return this.findOptionalEndTag(terminatingTagNameSets);
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            boolean bl = checkForEmptyElementTag = !HTMLElements.getEndTagRequiredElementNames().contains(this.name);
            if (checkForEmptyElementTag && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((nextEndTag = this.source.findNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag nextStartTag = this.source.findNextStartTag(this.end, this.name);
                if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
                    return nextEndTag;
                }
                if (this.source.logger.isInfoEnabled()) {
                    this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, nextStartTag.begin, nextStartTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] findResult = this.findEndTag(nextEndTag, checkForEmptyElementTag, Tag.isXMLName(this.name));
            if (findResult != null) {
                return (EndTag)findResult[0];
            }
        }
        if (this.source.logger.isInfoEnabled()) {
            this.source.logger.info(this.source.getRowColumnVector(this.begin).appendTo(new StringBuffer(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag findOptionalEndTag(HTMLElementTerminatingTagNameSets terminatingTagNameSets) {
        Tag tag;
        int pos = this.end;
        while (pos < this.source.end && (tag = Tag.findNextTag(this.source, pos)) != null) {
            Set terminatingTagNameSet;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                terminatingTagNameSet = terminatingTagNameSets.NonterminatingElementNameSet;
                if (terminatingTagNameSet != null && terminatingTagNameSet.contains(tag.name)) {
                    Element nonterminatingElement = ((StartTag)tag).getElement();
                    pos = nonterminatingElement.end;
                    continue;
                }
                terminatingTagNameSet = terminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (terminatingTagNameSet != null && terminatingTagNameSet.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            pos = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static char[] getStartDelimiterCharArray(String searchName) {
        if (searchName.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        char[] startDelimiterCharArray = Util.getConcatenatedCharArray("<", searchName);
        if (startDelimiterCharArray["<".length()] == '/') {
            throw new IllegalArgumentException("searchName argument \"" + searchName + "\" must not start with '/'");
        }
        return startDelimiterCharArray;
    }

    static StartTag findPrevious(Source source, int pos, String searchName, StartTagType searchStartTagType) {
        return StartTag.findPrevious(source, pos, searchName, searchStartTagType, searchStartTagType == StartTagType.NORMAL ? Tag.isXMLName(searchName) : true);
    }

    static StartTag findPrevious(Source source, int pos, String searchName, StartTagType searchStartTagType, boolean isXMLTagName) {
        if (searchName == null) {
            return (StartTag)source.findPreviousTag(pos, searchStartTagType);
        }
        char[] startDelimiterCharArray = StartTag.getStartDelimiterCharArray(searchName);
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            char lastSearchNameChar;
            if ((begin = parseText.lastIndexOf(startDelimiterCharArray, begin)) == -1) {
                return null;
            }
            StartTag startTag = (StartTag)Tag.getTagAt(source, begin, false);
            if (startTag == null || searchStartTagType != startTag.getStartTagType() && (searchStartTagType != StartTagType.NORMAL || isXMLTagName || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > searchName.length() && (lastSearchNameChar = searchName.charAt(searchName.length() - 1)) != ':' && Tag.isXMLNameChar(lastSearchNameChar)) continue;
            return startTag;
        } while ((begin -= 2) >= 0);
        return null;
    }

    static StartTag findNext(Source source, int pos, String searchName, StartTagType searchStartTagType) {
        return StartTag.findNext(source, pos, searchName, searchStartTagType, searchStartTagType == StartTagType.NORMAL ? Tag.isXMLName(searchName) : true);
    }

    static StartTag findNext(Source source, int pos, String searchName, StartTagType searchStartTagType, boolean isXMLTagName) {
        if (searchName == null) {
            return (StartTag)source.findNextTag(pos, searchStartTagType);
        }
        char[] startDelimiterCharArray = StartTag.getStartDelimiterCharArray(searchName);
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                char lastSearchNameChar;
                if ((begin = parseText.indexOf(startDelimiterCharArray, begin)) == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, begin, false);
                if (startTag == null || searchStartTagType != startTag.getStartTagType() && (searchStartTagType != StartTagType.NORMAL || isXMLTagName || !startTag.isUnregistered()) || startTag.getStartTagType().isNameAfterPrefixRequired() && startTag.getName().length() > searchName.length() && (lastSearchNameChar = searchName.charAt(searchName.length() - 1)) != ':' && Tag.isXMLNameChar(lastSearchNameChar)) continue;
                return startTag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static StartTag findPrevious(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.findPreviousTag(source, pos)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            --pos;
        }
        return null;
    }

    static StartTag findNext(Source source, int pos) {
        Tag tag;
        while ((tag = Tag.findNextTag(source, pos)) != null) {
            if (tag instanceof StartTag) {
                return (StartTag)tag;
            }
            ++pos;
        }
        return null;
    }

    static StartTag findNext(Source source, int pos, String attributeName, String value, boolean valueCaseSensitive) {
        if (value == null || attributeName.length() == 0) {
            throw new IllegalArgumentException();
        }
        String searchString = value.length() >= 3 || value.length() > 0 && attributeName.length() < 3 ? value : attributeName;
        char[] searchCharArray = searchString.toLowerCase().toCharArray();
        ParseText parseText = source.getParseText();
        int searchPos = pos;
        while (searchPos < source.end) {
            String attributeValue;
            StartTag startTag;
            if ((searchPos = parseText.indexOf(searchCharArray, searchPos)) == -1) {
                return null;
            }
            Tag tag = source.findEnclosingTag(searchPos);
            if (tag == null || !(tag instanceof StartTag)) {
                ++searchPos;
                continue;
            }
            if (tag.begin >= pos && (startTag = (StartTag)tag).getAttributes() != null && (attributeValue = startTag.getAttributes().getValue(attributeName)) != null) {
                if (value.equals(attributeValue)) {
                    return startTag;
                }
                if (value.equalsIgnoreCase(attributeValue)) {
                    if (!valueCaseSensitive) {
                        return startTag;
                    }
                    if (source.logger.isInfoEnabled()) {
                        source.logger.info(source.getRowColumnVector(searchPos).appendTo(new StringBuffer(200)).append(": StartTag with attribute ").append(attributeName).append("=\"").append(attributeValue).append("\" ignored during search because its case does not match search value \"").append(value).append('\"').toString());
                    }
                }
            }
            searchPos = tag.end + 5;
        }
        return null;
    }

    private Segment[] findEndTag(EndTag nextEndTag, boolean checkForEmptyElementTag, boolean isXMLTagName) {
        StartTag nextStartTag = StartTag.findNext(this.source, this.end, this.name, this.startTagType, isXMLTagName);
        if (checkForEmptyElementTag) {
            while (nextStartTag != null && nextStartTag.isSyntacticalEmptyElementTag()) {
                nextStartTag = StartTag.findNext(this.source, nextStartTag.end, this.name, this.startTagType, isXMLTagName);
            }
        }
        return this.findEndTag(this.end, nextStartTag, nextEndTag, checkForEmptyElementTag, isXMLTagName);
    }

    private Segment[] findEndTag(int afterPos, StartTag nextStartTag, EndTag nextEndTag, boolean checkForEmptyElementTag, boolean isXMLTagName) {
        if (nextEndTag == null) {
            return null;
        }
        Segment[] returnArray = new Segment[]{nextEndTag, nextStartTag};
        if (nextStartTag == null || nextStartTag.begin > nextEndTag.begin) {
            return returnArray;
        }
        Segment[] findResult = nextStartTag.findEndTag(nextEndTag, checkForEmptyElementTag, isXMLTagName);
        if (findResult == null) {
            return null;
        }
        EndTag nextStartTagsEndTag = (EndTag)findResult[0];
        EndTag nextNextEndTag = EndTag.findNext(this.source, nextStartTagsEndTag.end, nextEndTag.getName(), nextEndTag.getEndTagType());
        return this.findEndTag(nextStartTagsEndTag.end, (StartTag)findResult[1], nextNextEndTag, checkForEmptyElementTag, isXMLTagName);
    }
}

