/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTagType;
import au.id.jericho.lib.html.HTMLElementName;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.ParseText;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.TagType;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Tag
extends Segment
implements HTMLElementName {
    String name = null;
    private Object userData = null;
    Element element = Element.NOT_CACHED;
    private Tag previousTag = NOT_CACHED;
    private Tag nextTag = NOT_CACHED;
    static final Tag NOT_CACHED = new StartTag();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int begin, int end, String name) {
        super(source, begin, end);
        this.name = HTMLElements.getConstantElementName(name.toLowerCase());
    }

    Tag() {
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int nameSegmentBegin = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, nameSegmentBegin, nameSegmentBegin + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Tag findNextTag() {
        if (this.nextTag == NOT_CACHED) {
            this.nextTag = Tag.findNextTag(this.source, this.begin + 1);
        }
        return this.nextTag;
    }

    public Tag findPreviousTag() {
        if (this.previousTag == NOT_CACHED) {
            this.previousTag = Tag.findPreviousTag(this.source, this.begin - 1);
        }
        return this.previousTag;
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence text) {
        if (text == null || text.length() == 0 || !Tag.isXMLNameStartChar(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < text.length(); ++i) {
            if (Tag.isXMLNameChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == ':';
    }

    public static final boolean isXMLNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
    }

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag findPreviousTag(Source source, int pos) {
        return source.useAllTypesCache ? source.cache.findPreviousTag(pos) : Tag.findPreviousTagUncached(source, pos, -1);
    }

    static final Tag findNextTag(Source source, int pos) {
        return source.useAllTypesCache ? source.cache.findNextTag(pos) : Tag.findNextTagUncached(source, pos, -1);
    }

    static final Tag findPreviousTagUncached(Source source, int pos, int breakAtPos) {
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf('<', begin, breakAtPos)) == -1) {
                return null;
            }
            Tag tag = Tag.getTagAt(source, begin, false);
            if (tag == null || !tag.includeInSearch()) continue;
            return tag;
        } while (--begin >= 0);
        return null;
    }

    static final Tag findNextTagUncached(Source source, int pos, int breakAtPos) {
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf('<', begin, breakAtPos)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag findPreviousTag(Source source, int pos, TagType tagType) {
        if (source.useSpecialTypesCache) {
            return source.cache.findPreviousTag(pos, tagType);
        }
        return Tag.findPreviousTagUncached(source, pos, tagType, -1);
    }

    static final Tag findNextTag(Source source, int pos, TagType tagType) {
        if (source.useSpecialTypesCache) {
            return source.cache.findNextTag(pos, tagType);
        }
        return Tag.findNextTagUncached(source, pos, tagType, -1);
    }

    static final Tag findPreviousTagUncached(Source source, int pos, TagType tagType, int breakAtPos) {
        if (tagType == null) {
            return Tag.findPreviousTagUncached(source, pos, breakAtPos);
        }
        char[] startDelimiterCharArray = tagType.getStartDelimiterCharArray();
        ParseText parseText = source.getParseText();
        int begin = pos;
        do {
            if ((begin = parseText.lastIndexOf(startDelimiterCharArray, begin, breakAtPos)) == -1) {
                return null;
            }
            Tag tag = Tag.getTagAt(source, begin, false);
            if (tag == null || tag.getTagType() != tagType) continue;
            return tag;
        } while (--begin >= 0);
        return null;
    }

    static final Tag findNextTagUncached(Source source, int pos, TagType tagType, int breakAtPos) {
        if (tagType == null) {
            return Tag.findNextTagUncached(source, pos, breakAtPos);
        }
        char[] startDelimiterCharArray = tagType.getStartDelimiterCharArray();
        try {
            ParseText parseText = source.getParseText();
            int begin = pos;
            do {
                if ((begin = parseText.indexOf(startDelimiterCharArray, begin, breakAtPos)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, begin, false);
                if (tag == null || tag.getTagType() != tagType) continue;
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int pos, boolean serverTagOnly) {
        return source.useAllTypesCache ? source.cache.getTagAt(pos, serverTagOnly) : Tag.getTagAtUncached(source, pos, serverTagOnly);
    }

    static final Tag getTagAtUncached(Source source, int pos, boolean serverTagOnly) {
        return TagType.getTagAt(source, pos, serverTagOnly, false);
    }

    static final Tag[] parseAll(Source source, boolean assumeNoNestedTags) {
        int registeredTagCount = 0;
        int registeredStartTagCount = 0;
        ArrayList<Tag> list = new ArrayList<Tag>();
        source.fullSequentialParseData = new int[1];
        if (source.end != 0) {
            ParseText parseText = source.getParseText();
            Tag tag = Tag.parseAllFindNextTag(source, parseText, 0, assumeNoNestedTags);
            while (tag != null) {
                int pos;
                list.add(tag);
                if (!tag.isUnregistered()) {
                    ++registeredTagCount;
                    if (tag instanceof StartTag) {
                        ++registeredStartTagCount;
                    }
                }
                int n = pos = assumeNoNestedTags && !tag.isUnregistered() ? tag.end : tag.begin + 1;
                if (pos == source.end) break;
                tag = Tag.parseAllFindNextTag(source, parseText, pos, assumeNoNestedTags);
            }
        }
        Tag[] allRegisteredTags = new Tag[registeredTagCount];
        StartTag[] allRegisteredStartTags = new StartTag[registeredStartTagCount];
        source.cache.loadAllTags(list, allRegisteredTags, allRegisteredStartTags);
        source.allTagsArray = allRegisteredTags;
        source.allTags = Arrays.asList(allRegisteredTags);
        source.allStartTags = Arrays.asList(allRegisteredStartTags);
        int lastIndex = allRegisteredTags.length - 1;
        for (int i = 0; i < allRegisteredTags.length; ++i) {
            Tag tag = allRegisteredTags[i];
            tag.previousTag = i > 0 ? allRegisteredTags[i - 1] : null;
            tag.nextTag = i < lastIndex ? allRegisteredTags[i + 1] : null;
        }
        return allRegisteredTags;
    }

    private static final Tag parseAllFindNextTag(Source source, ParseText parseText, int pos, boolean assumeNoNestedTags) {
        try {
            int begin = pos;
            do {
                if ((begin = parseText.indexOf('<', begin)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source, begin, false, assumeNoNestedTags);
                if (tag == null) continue;
                if (!assumeNoNestedTags) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && tag.name == "script" ? Integer.MAX_VALUE : tag.end;
                    }
                }
                return tag;
            } while (++begin < source.end);
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        return null;
    }
}

