/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.NodeIterator;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;
    private static Map map = TextExtractor.initDefaultAttributeIncludeCheckerMap();
    private static AttributeIncludeChecker ALWAYS_INCLUDE = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return true;
        }
    };
    private static AttributeIncludeChecker INCLUDE_IF_NAME_ATTRIBUTE_PRESENT = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return startTag.getAttributes().get("name") != null;
        }
    };

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean convertNonBreakingSpaces) {
        this.convertNonBreakingSpaces = convertNonBreakingSpaces;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean includeAttributes) {
        this.includeAttributes = includeAttributes;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public boolean includeAttribute(StartTag startTag, Attribute attribute) {
        AttributeIncludeChecker attributeIncludeChecker = (AttributeIncludeChecker)map.get(attribute.getKey());
        if (attributeIncludeChecker == null) {
            return false;
        }
        return attributeIncludeChecker.includeAttribute(startTag, attribute);
    }

    public TextExtractor setExcludeNonHTMLElements(boolean excludeNonHTMLElements) {
        this.excludeNonHTMLElements = excludeNonHTMLElements;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private static Map initDefaultAttributeIncludeCheckerMap() {
        HashMap<String, AttributeIncludeChecker> map = new HashMap<String, AttributeIncludeChecker>();
        map.put("title", ALWAYS_INCLUDE);
        map.put("alt", ALWAYS_INCLUDE);
        map.put("label", ALWAYS_INCLUDE);
        map.put("summary", ALWAYS_INCLUDE);
        map.put("content", INCLUDE_IF_NAME_ATTRIBUTE_PRESENT);
        map.put("href", ALWAYS_INCLUDE);
        return map;
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean convertNonBreakingSpaces, boolean includeAttributes, boolean excludeNonHTMLElements) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = convertNonBreakingSpaces;
            this.includeAttributes = includeAttributes;
            this.excludeNonHTMLElements = excludeNonHTMLElements;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.segment.length());
            NodeIterator nodeIterator = new NodeIterator(this.segment);
            while (nodeIterator.hasNext()) {
                Segment nodeSegment = nodeIterator.getNextSegment();
                if (nodeSegment instanceof Tag) {
                    Tag tag = (Tag)nodeSegment;
                    if (tag.getTagType().isServerTag()) {
                        boolean elementContainsMarkup = false;
                        Element element = tag.getElement();
                        if (element == null || element.getEnd() <= tag.getEnd()) continue;
                        nodeIterator.skipToPos(element.getEnd());
                        continue;
                    }
                    if (tag.getTagType() == StartTagType.NORMAL) {
                        StartTag startTag = (StartTag)tag;
                        if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                            nodeIterator.skipToPos(startTag.getElement().getEnd());
                            continue;
                        }
                        if (this.includeAttributes) {
                            Iterator attributeIterator = startTag.getAttributes().iterator();
                            while (attributeIterator.hasNext()) {
                                Attribute attribute = (Attribute)attributeIterator.next();
                                if (!TextExtractor.this.includeAttribute(startTag, attribute)) continue;
                                sb.append(' ').append((Object)attribute.getValueSegment()).append(' ');
                            }
                        }
                    }
                    if (tag.getName() != "br" && HTMLElements.getInlineLevelElementNames().contains(tag.getName())) continue;
                    sb.append(' ');
                    continue;
                }
                Util.appendTo(sb, (CharSequence)nodeSegment);
            }
            String decodedText = CharacterReference.decodeCollapseWhiteSpace(sb, this.convertNonBreakingSpaces);
            return decodedText;
        }
    }

    private static interface AttributeIncludeChecker {
        public boolean includeAttribute(StartTag var1, Attribute var2);
    }
}

