/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.AbstractBytesStore;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.cleaner.CleanerServiceLocator;
import net.openhft.chronicle.core.cleaner.spi.ByteBufferCleanerService;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.WeakReferenceCleaner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class NativeBytesStore<Underlying>
extends AbstractBytesStore<NativeBytesStore<Underlying>, Underlying> {
    private static final long MEMORY_MAPPED_SIZE = 131072L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeBytesStore.class);
    private static final Field BB_ADDRESS;
    private static final Field BB_CAPACITY;
    private static final Field BB_ATT;
    private static final ByteBufferCleanerService CLEANER_SERVICE;
    @Nullable
    private final Throwable createdHere = Jvm.isDebug() ? new StackTrace("Created here") : null;
    protected long address;
    protected Memory memory = OS.memory();
    protected volatile Throwable releasedHere;
    protected long maximumLimit;
    @Nullable
    private WeakReferenceCleaner cleaner;
    private boolean elastic;
    @Nullable
    private Underlying underlyingObject;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);

    private NativeBytesStore() {
    }

    private NativeBytesStore(@NotNull ByteBuffer bb, boolean elastic) {
        this.init(bb, elastic);
    }

    public NativeBytesStore(long address, long maximumLimit) {
        this(address, maximumLimit, null, false);
    }

    public NativeBytesStore(long address, long maximumLimit, @Nullable Runnable deallocator, boolean elastic) {
        this.setAddress(address);
        this.maximumLimit = maximumLimit;
        this.cleaner = deallocator == null ? null : WeakReferenceCleaner.newCleaner((Object)this, (Runnable)deallocator);
        this.underlyingObject = null;
        this.elastic = elastic;
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new NativeBytesStore<ByteBuffer>(bb, false);
    }

    @NotNull
    public static <T> NativeBytesStore<T> uninitialized() {
        return new NativeBytesStore();
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStore(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, true);
    }

    @NotNull
    private static NativeBytesStore<Void> of(long capacity, boolean zeroOut, boolean elastic) throws IllegalArgumentException {
        Memory memory = OS.memory();
        long address = memory.allocate(capacity);
        if (zeroOut || capacity < 131072L) {
            memory.setMemory(address, capacity, (byte)0);
            memory.storeFence();
        }
        Deallocator deallocator = new Deallocator(address, capacity);
        return new NativeBytesStore<Void>(address, capacity, deallocator, elastic);
    }

    @NotNull
    public static NativeBytesStore<Void> nativeStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, true, false);
    }

    @NotNull
    public static NativeBytesStore<Void> lazyNativeBytesStoreWithFixedCapacity(long capacity) throws IllegalArgumentException {
        return NativeBytesStore.of(capacity, false, false);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer() {
        return NativeBytesStore.elasticByteBuffer(OS.pageSize(), Long.MAX_VALUE);
    }

    @NotNull
    public static NativeBytesStore<ByteBuffer> elasticByteBuffer(int size, long maxSize) {
        return new NativeBytesStore<ByteBuffer>(ByteBuffer.allocateDirect(size), true);
    }

    @NotNull
    public static NativeBytesStore from(@NotNull String text) {
        return NativeBytesStore.from(text.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static NativeBytesStore from(@NotNull byte[] bytes) {
        try {
            NativeBytesStore<Void> nbs = NativeBytesStore.nativeStore(bytes.length);
            Bytes.wrapForRead(bytes).copyTo(nbs);
            return nbs;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    public void init(@NotNull ByteBuffer bb, boolean elastic) {
        this.elastic = elastic;
        this.underlyingObject = bb;
        this.setAddress(((DirectBuffer)((Object)bb)).address());
        this.maximumLimit = bb.capacity();
    }

    public void uninit() {
        this.underlyingObject = null;
        this.address = 0L;
        this.maximumLimit = 0L;
        this.cleaner = null;
    }

    @Override
    public void move(long from, long to, long length) throws BufferUnderflowException {
        if (from < 0L || to < 0L) {
            throw new BufferUnderflowException();
        }
        OS.memory().copyMemory(this.address + from, this.address + to, length);
    }

    @Override
    @NotNull
    public BytesStore<NativeBytesStore<Underlying>, Underlying> copy() {
        try {
            if (this.underlyingObject == null) {
                NativeBytesStore<Void> copy = NativeBytesStore.of(this.realCapacity(), false, true);
                this.memory.copyMemory(this.address, copy.address, this.capacity());
                return copy;
            }
            if (this.underlyingObject instanceof ByteBuffer) {
                ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.capacity()));
                bb.put((ByteBuffer)this.underlyingObject);
                bb.clear();
                return NativeBytesStore.wrap(bb);
            }
            throw new UnsupportedOperationException();
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public VanillaBytes<Underlying> bytesForWrite() throws IllegalStateException {
        return this.elastic ? new NativeBytes(this) : new VanillaBytes(this);
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.maximumLimit;
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.maximumLimit;
    }

    @Override
    @ForceInline
    @Nullable
    public Underlying underlyingObject() {
        return this.underlyingObject;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> zeroOut(long start, long end) {
        if (end <= start) {
            return this;
        }
        if (start < this.start()) {
            start = this.start();
        }
        if (end > this.capacity()) {
            end = this.capacity();
        }
        this.memory.setMemory(this.address + this.translate(start), end - start, (byte)0);
        return this;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        return this.memory.compareAndSwapInt(this.address + this.translate(offset), expected, value);
    }

    @Override
    public void testAndSetInt(long offset, int expected, int value) {
        this.memory.testAndSetInt(this.address + this.translate(offset), offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        return this.memory.compareAndSwapLong(this.address + this.translate(offset), expected, value);
    }

    @Override
    @ForceInline
    public long addAndGetLong(long offset, long adding) throws BufferUnderflowException {
        return this.memory.addLong(this.address + this.translate(offset), adding);
    }

    @Override
    @ForceInline
    public int addAndGetInt(long offset, int adding) throws BufferUnderflowException {
        return this.memory.addInt(this.address + this.translate(offset), adding);
    }

    protected long translate(long offset) {
        return offset;
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
        if (Jvm.isDebug() && this.refCount.get() == 0L) {
            this.releasedHere = new Error("Released here");
        }
    }

    public long refCount() {
        return this.refCount.get();
    }

    public boolean tryReserve() {
        return this.refCount.tryReserve();
    }

    @Override
    @ForceInline
    public byte readByte(long offset) {
        if (Jvm.isDebug()) {
            this.checkReleased();
        }
        return this.memory.readByte(this.address + this.translate(offset));
    }

    @Override
    public int readUnsignedByte(long offset) throws BufferUnderflowException {
        return this.readByte(offset) & 0xFF;
    }

    public void checkReleased() {
        if (this.releasedHere != null) {
            throw new InternalError("Accessing a released resource", this.releasedHere);
        }
    }

    @Override
    @ForceInline
    public short readShort(long offset) {
        return this.memory.readShort(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public int readInt(long offset) {
        return this.memory.readInt(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public long readLong(long offset) {
        long address = this.address;
        assert (address != 0L);
        return this.memory.readLong(address + this.translate(offset));
    }

    @Override
    @ForceInline
    public float readFloat(long offset) {
        return this.memory.readFloat(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public double readDouble(long offset) {
        return this.memory.readDouble(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public byte readVolatileByte(long offset) {
        return this.memory.readVolatileByte(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public short readVolatileShort(long offset) {
        return this.memory.readVolatileShort(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public int readVolatileInt(long offset) {
        return this.memory.readVolatileInt(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    public long readVolatileLong(long offset) {
        return this.memory.readVolatileLong(this.address + this.translate(offset));
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeByte(long offset, byte i8) {
        this.memory.writeByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeShort(long offset, short i16) {
        this.memory.writeShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeInt(long offset, int i32) {
        this.memory.writeInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedInt(long offset, int i) {
        this.memory.writeOrderedInt(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeLong(long offset, long i64) {
        this.memory.writeLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeOrderedLong(long offset, long i) {
        this.memory.writeOrderedLong(this.address + this.translate(offset), i);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeFloat(long offset, float f) {
        this.memory.writeFloat(this.address + this.translate(offset), f);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeDouble(long offset, double d) {
        this.memory.writeDouble(this.address + this.translate(offset), d);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileByte(long offset, byte i8) {
        this.memory.writeVolatileByte(this.address + this.translate(offset), i8);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileShort(long offset, short i16) {
        this.memory.writeVolatileShort(this.address + this.translate(offset), i16);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileInt(long offset, int i32) {
        this.memory.writeVolatileInt(this.address + this.translate(offset), i32);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> writeVolatileLong(long offset, long i64) {
        this.memory.writeVolatileLong(this.address + this.translate(offset), i64);
        return this;
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.memory.copyMemory(bytes, offset, this.address + this.translate(offsetInRDO), length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) {
        if (bytes.isDirect()) {
            this.memory.copyMemory(((DirectBuffer)((Object)bytes)).address() + (long)offset, this.address + this.translate(offsetInRDO), (long)length);
        } else {
            this.memory.copyMemory(bytes.array(), offset, this.address + this.translate(offsetInRDO), length);
        }
    }

    @Override
    @ForceInline
    @NotNull
    public NativeBytesStore<Underlying> write(long writeOffset, @NotNull RandomDataInput bytes, long readOffset, long length) throws BufferOverflowException, BufferUnderflowException {
        if (bytes.isDirectMemory()) {
            this.memory.copyMemory(bytes.addressForRead(readOffset), this.addressForWrite(writeOffset), length);
        } else {
            this.write0(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    public void write0(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) throws BufferUnderflowException {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offsetInRDO + i, bytes.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(offsetInRDO + i, bytes.readByte(offset + i));
            ++i;
        }
    }

    @Override
    public long addressForRead(long offset) throws BufferUnderflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            throw new BufferUnderflowException();
        }
        return this.address + this.translate(offset);
    }

    @Override
    public long addressForWrite(long offset) throws BufferOverflowException {
        if (offset < this.start() || offset > this.realCapacity()) {
            throw new BufferOverflowException();
        }
        return this.address + this.translate(offset);
    }

    private synchronized void performRelease() {
        this.memory = null;
        if (this.refCount.get() > 0L) {
            LOGGER.info("NativeBytesStore discarded without releasing ", this.createdHere);
        }
        if (this.releasedHere == null) assert ((this.releasedHere = new StackTrace()) != null);
        if (this.cleaner != null) {
            this.cleaner.scheduleForClean();
        } else if (this.underlyingObject instanceof ByteBuffer) {
            CLEANER_SERVICE.clean((ByteBuffer)this.underlyingObject);
        }
    }

    @Override
    @NotNull
    public String toString() {
        try {
            return BytesInternal.toString(this);
        }
        catch (IllegalStateException e) {
            return e.toString();
        }
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) throws BufferUnderflowException {
        this.memory.copyMemory(this.addressForRead(position), address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) throws BufferOverflowException {
        this.memory.copyMemory(address, this.addressForWrite(position), size);
    }

    void write8bit(long position, char[] chars, int offset, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = this.memory;
        for (int i = 0; i < length; ++i) {
            memory.writeByte(addr + (long)i, (byte)chars[offset + i]);
        }
    }

    void read8bit(long position, char[] chars, int length) {
        long addr = this.address + this.translate(position);
        Memory memory = OS.memory();
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(memory.readByte(addr + (long)i) & 0xFF);
        }
    }

    @Override
    public long readIncompleteLong(long offset) {
        int remaining = (int)Math.min(8L, this.readRemaining() - offset);
        long l = 0L;
        for (int i = 0; i < remaining; ++i) {
            byte b = this.memory.readByte(this.address + offset + (long)i);
            l |= (long)(b & 0xFF) << i * 8;
        }
        return l;
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
    }

    public void setAddress(long address) {
        if ((address & 0xFFFFFFFFFFFFC000L) == 0L) {
            throw new AssertionError((Object)("Invalid addressForRead " + Long.toHexString(address)));
        }
        this.address = address;
    }

    @Deprecated
    public long appendUTF(long pos, char[] chars, int offset, int length) throws BufferOverflowException {
        return this.appendUtf8(pos, chars, offset, length);
    }

    public long appendUtf8(long pos, char[] chars, int offset, int length) throws BufferOverflowException {
        int i;
        block6: {
            if (pos + (long)length > this.realCapacity()) {
                throw new BufferOverflowException();
            }
            long address = this.address + this.translate(0L);
            Memory memory = this.memory;
            if (memory == null) {
                throw new NullPointerException();
            }
            Unsafe unsafe = UnsafeMemory.UNSAFE;
            for (i = 0; i < length - 3; i += 4) {
                int i2 = offset + i;
                char c0 = chars[i2];
                char c1 = chars[i2 + 1];
                char c2 = chars[i2 + 2];
                char c3 = chars[i2 + 3];
                if ((c0 | c1 | c2 | c3) <= 127) {
                    int value = c0 | c1 << 8 | c2 << 16 | c3 << 24;
                    unsafe.putInt(address + pos, value);
                    pos += 4L;
                    continue;
                }
                break block6;
            }
            while (i < length) {
                char c = chars[offset + i];
                if (c <= '\u007f') {
                    unsafe.putByte(address + pos++, (byte)c);
                    ++i;
                    continue;
                }
                break block6;
            }
            return pos;
        }
        return this.appendUtf8a(pos, chars, offset, length, i);
    }

    private long appendUtf8a(long pos, char[] chars, int offset, int length, int i) {
        while (i < length) {
            char c = chars[offset + i];
            if (c <= '\u007f') {
                this.writeByte(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                this.writeByte(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            } else {
                this.writeByte(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte(pos++, (byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
        return pos;
    }

    @Override
    public long copyTo(@NotNull BytesStore store) {
        if (store.isDirectMemory()) {
            return this.copyToDirect(store);
        }
        return super.copyTo(store);
    }

    public long copyToDirect(@NotNull BytesStore store) {
        long read = Math.min(this.readRemaining(), this.writeRemaining());
        if (read > 0L) {
            try {
                long addr = this.address;
                long addr2 = store.addressForWrite(0L);
                this.memory.copyMemory(addr, addr2, read);
            }
            catch (BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        return read;
    }

    @Override
    @NotNull
    public ByteBuffer toTemporaryDirectByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(0);
        try {
            BB_ADDRESS.setLong(bb, this.address);
            BB_CAPACITY.setInt(bb, Maths.toUInt31((long)this.readRemaining()));
            BB_ATT.set(bb, this);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        bb.clear();
        return bb;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        return this.byteCheckSum(this.start(), this.readLimit());
    }

    @Override
    public int byteCheckSum(long position, long limit) {
        long ptr;
        Memory memory = this.memory;
        assert (memory != null);
        int b = 0;
        long end = this.address + limit;
        for (ptr = this.address + position; ptr < end - 7L; ptr += 8L) {
            b += memory.readByte(ptr) + memory.readByte(ptr + 1L) + memory.readByte(ptr + 2L) + memory.readByte(ptr + 3L) + memory.readByte(ptr + 4L) + memory.readByte(ptr + 5L) + memory.readByte(ptr + 6L) + memory.readByte(ptr + 7L);
        }
        while (ptr < end) {
            b += memory.readByte(ptr);
            ++ptr;
        }
        return b & 0xFF;
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    @Override
    public long read(long offsetInRDI, byte[] bytes, int offset, int length) {
        int i;
        int len = (int)Math.min((long)length, this.readLimit() - offsetInRDI);
        long offset2 = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        long address = this.address + this.translate(offsetInRDI);
        for (i = 0; i < len - 7; i += 8) {
            UnsafeMemory.UNSAFE.putLong(bytes, offset2 + (long)i, this.memory.readLong(address + (long)i));
        }
        if (i < len - 3) {
            UnsafeMemory.UNSAFE.putInt(bytes, offset2 + (long)i, this.memory.readInt(address + (long)i));
            i += 4;
        }
        while (i < len) {
            UnsafeMemory.UNSAFE.putByte(bytes, offset2 + (long)i, this.memory.readByte(address + (long)i));
            ++i;
        }
        return len;
    }

    @Override
    public int peekUnsignedByte(long offset) {
        long address = this.address;
        Memory memory = this.memory;
        long translate = this.translate(offset);
        long address2 = address + translate;
        int ret = translate >= this.maximumLimit ? -1 : memory.readByte(address2) & 0xFF;
        return ret;
    }

    @Override
    public int fastHash(long offset, int length) throws BufferUnderflowException {
        long ret;
        switch (length) {
            case 0: {
                return 0;
            }
            case 1: {
                ret = this.readByte(offset);
                break;
            }
            case 2: {
                ret = this.readShort(offset);
                break;
            }
            case 4: {
                ret = this.readInt(offset);
                break;
            }
            case 8: {
                ret = (long)this.readInt(offset) * 1829709757L + (long)this.readInt(offset + 4L);
                break;
            }
            default: {
                return super.fastHash(offset, length);
            }
        }
        long hash = ret * -2057448229L;
        return (int)(hash ^ hash >> 32);
    }

    @Override
    public long safeLimit() {
        return this.maximumLimit;
    }

    static {
        CLEANER_SERVICE = CleanerServiceLocator.cleanerService();
        Class<?> directBB = ByteBuffer.allocateDirect(0).getClass();
        BB_ADDRESS = Jvm.getField(directBB, (String)"address");
        BB_CAPACITY = Jvm.getField(directBB, (String)"capacity");
        BB_ATT = Jvm.getField(directBB, (String)"att");
    }

    static class Deallocator
    implements Runnable {
        private volatile long address;
        private volatile long size;

        Deallocator(long address, long size) {
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            long addressToFree = this.address;
            this.address = 0L;
            OS.memory().freeMemory(addressToFree, this.size);
        }
    }
}

