/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class ReflectionUtil {
    private static final String ANALYTICS_NAME = "net.openhft.chronicle.analytics.Analytics";

    private ReflectionUtil() {
    }

    public static boolean analyticsPresent() {
        try {
            Class.forName(ANALYTICS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    @NotNull
    public static Object analyticsBuilder(@NotNull String measurementId, @NotNull String apiSecret) {
        ObjectUtils.requireNonNull(measurementId);
        ObjectUtils.requireNonNull(apiSecret);
        try {
            Method method = ReflectionUtil.methodOrThrow(ANALYTICS_NAME, "builder", String.class, String.class);
            return method.invoke(null, measurementId, apiSecret);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw Jvm.rethrow(e);
        }
    }

    @NotNull
    public static Method methodOrThrow(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        ObjectUtils.requireNonNull(className);
        ObjectUtils.requireNonNull(methodName);
        try {
            Class<?> analyticsClass = Class.forName(className);
            return analyticsClass.getMethod(methodName, parameterTypes);
        }
        catch (ReflectiveOperationException e) {
            throw Jvm.rethrow(e);
        }
    }

    public static Object invokeOrThrow(@NotNull Method method, @NotNull Object target, Object ... params) {
        ObjectUtils.requireNonNull(method);
        ObjectUtils.requireNonNull(target);
        try {
            return method.invoke(target, params);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw Jvm.rethrow(e);
        }
    }

    @NotNull
    public static <T> T reflectiveProxy(@NotNull Class<T> interf, @NotNull Object delegate) throws IllegalArgumentException {
        ObjectUtils.requireNonNull(interf);
        ObjectUtils.requireNonNull(delegate);
        Class[] interfaces = new Class[]{interf};
        return Jvm.uncheckedCast(Proxy.newProxyInstance(delegate.getClass().getClassLoader(), interfaces, (InvocationHandler)new ReflectiveInvocationHandler(delegate, false)));
    }

    @NotNull
    public static <T> T reflectiveProxy(@NotNull Class<T> interf, @NotNull Object delegate, boolean returnProxy) throws IllegalArgumentException {
        ObjectUtils.requireNonNull(interf);
        ObjectUtils.requireNonNull(delegate);
        Class[] interfaces = new Class[]{interf};
        return Jvm.uncheckedCast(Proxy.newProxyInstance(delegate.getClass().getClassLoader(), interfaces, (InvocationHandler)new ReflectiveInvocationHandler(delegate, returnProxy)));
    }

    private static final class ReflectiveInvocationHandler
    implements InvocationHandler {
        private final Object delegate;
        private final boolean returnProxy;

        public ReflectiveInvocationHandler(@NotNull Object delegate, boolean returnProxy) {
            this.delegate = ObjectUtils.requireNonNull(delegate);
            this.returnProxy = ObjectUtils.requireNonNull(returnProxy);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class[] parameterTypes = args == null ? null : (Class[])Stream.of(args).map(Object::getClass).toArray(Class[]::new);
            Method delegateMethod = this.delegate.getClass().getMethod(method.getName(), parameterTypes);
            Object result = delegateMethod.invoke(this.delegate, args);
            if (this.returnProxy && !"build".equals(method.getName())) {
                return proxy;
            }
            return result;
        }
    }
}

