/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.NumberHeapMemberGenerator;
import net.openhft.chronicle.values.PrimitiveFieldModel;
import net.openhft.chronicle.values.Primitives;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;

class FloatingFieldModel
extends PrimitiveFieldModel {
    private final MemberGenerator nativeGenerator = new MemberGenerator(this){

        @Override
        void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
        }

        private int verifiedByteOffset(ValueBuilder valueBuilder) {
            int bitOffset = valueBuilder.model.fieldBitOffset(FloatingFieldModel.this);
            assert (bitOffset % 8 == 0);
            return bitOffset / 8;
        }

        private String scaledIndex() {
            if (FloatingFieldModel.this.type == Float.TYPE) {
                return "(4L * index)";
            }
            if (FloatingFieldModel.this.type == Double.TYPE) {
                return "(8L * index)";
            }
            throw new AssertionError();
        }

        private void gen(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String ret, String method, String arguments) {
            methodBuilder.addStatement("$Nbs.$N$N(offset + $L$N)", new Object[]{ret, method, FloatingFieldModel.this.capTypeName(), this.verifiedByteOffset(valueBuilder), arguments});
        }

        private void genArrayElement(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String ret, String method, String arguments) {
            methodBuilder.addStatement("$Nbs.$N$N(offset + $L + $N$N)", new Object[]{ret, method, FloatingFieldModel.this.capTypeName(), arrayFieldModel.verifiedByteOffset(valueBuilder), this.scaledIndex(), arguments});
        }

        @Override
        void generateGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "return ", "read", "");
        }

        @Override
        void generateArrayElementGet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "return ", "read", "");
        }

        @Override
        void generateGetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "return ", "readVolatile", "");
        }

        @Override
        void generateArrayElementGetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "return ", "readVolatile", "");
        }

        @Override
        void generateSet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "", "write", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateArrayElementSet(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "", "write", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateSetVolatile(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "", "writeVolatile", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateArrayElementSetVolatile(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "", "writeVolatile", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateSetOrdered(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "", "writeOrdered", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateArrayElementSetOrdered(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "", "writeOrdered", ", " + FloatingFieldModel.this.varName());
        }

        @Override
        void generateAdd(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addStatement("return bs.addAndGet$NNotAtomic(offset + $L, addition)", new Object[]{FloatingFieldModel.this.capTypeName(), this.verifiedByteOffset(valueBuilder)});
        }

        @Override
        void generateArrayElementAdd(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            methodBuilder.addStatement("return bs.writeAndGet$NNotAtomic(offset + $L + $N, addition)", new Object[]{FloatingFieldModel.this.capTypeName(), arrayFieldModel.verifiedByteOffset(valueBuilder), this.scaledIndex()});
        }

        @Override
        void generateAddAtomic(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "return ", "addAndGet", ", addition");
        }

        @Override
        void generateArrayElementAddAtomic(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "return ", "addAndGet", ", addition");
        }

        @Override
        void generateCompareAndSwap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "return ", "compareAndSwap", String.format(", %s, %s", FloatingFieldModel.this.oldName(), FloatingFieldModel.this.newName()));
        }

        @Override
        void generateArrayElementCompareAndSwap(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            arrayFieldModel.checkBounds(methodBuilder);
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "return ", "compareAndSwap", String.format(", %s, %s", FloatingFieldModel.this.oldName(), FloatingFieldModel.this.newName()));
        }

        @Override
        void generateCopyFrom(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "", "write", String.format(", from.%s()", FloatingFieldModel.this.getOrGetVolatile().getName()));
        }

        @Override
        void generateArrayElementCopyFrom(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "", "write", String.format(", from.%s(index)", arrayFieldModel.getOrGetVolatile().getName()));
        }

        @Override
        void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.gen(valueBuilder, methodBuilder, "", "write", String.format(", bytes.read%s()", FloatingFieldModel.this.capTypeName()));
        }

        @Override
        void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            this.genArrayElement(arrayFieldModel, valueBuilder, methodBuilder, "", "write", String.format(", bytes.read%s()", FloatingFieldModel.this.capTypeName()));
        }

        @Override
        void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            methodBuilder.addCode("if ($N($N()) != $N(other.$N())) return false;\n", new Object[]{FloatingFieldModel.this.toBits(), FloatingFieldModel.this.getOrGetVolatile().getName(), FloatingFieldModel.this.toBits(), FloatingFieldModel.this.getOrGetVolatile().getName()});
        }

        @Override
        void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            String get = arrayFieldModel.getOrGetVolatile().getName();
            methodBuilder.addCode("if ($N($N(index)) != $N(other.$N(index))) return false;\n", new Object[]{FloatingFieldModel.this.toBits(), get, FloatingFieldModel.this.toBits(), get});
        }

        @Override
        String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("%s.hashCode(%s())", Primitives.boxed(FloatingFieldModel.this.type).getName(), FloatingFieldModel.this.getOrGetVolatile().getName());
        }

        @Override
        String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
            return String.format("%s.hashCode(%s(index))", Primitives.boxed(FloatingFieldModel.this.type).getName(), arrayFieldModel.getOrGetVolatile().getName());
        }
    };

    FloatingFieldModel() {
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new NumberHeapMemberGenerator(this){

            @Override
            public void generateAddAtomic(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.beginControlFlow("while (true)", new Object[0]);
                methodBuilder.addStatement("$T $N = " + this.wrap(valueBuilder, methodBuilder, "$N.$N(this, $N)"), new Object[]{FloatingFieldModel.this.type, FloatingFieldModel.this.oldName(), valueBuilder.unsafe(), this.getVolatile(), this.fieldOffset(valueBuilder)});
                methodBuilder.addStatement("$T $N = $N + addition", new Object[]{FloatingFieldModel.this.type, FloatingFieldModel.this.newName(), FloatingFieldModel.this.oldName()});
                methodBuilder.beginControlFlow(String.format("if ($N.$N(this, $N, %s, %s))", this.unwrap(methodBuilder, "$N"), this.unwrap(methodBuilder, "$N")), new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.fieldOffset(valueBuilder), FloatingFieldModel.this.oldName(), FloatingFieldModel.this.newName()});
                methodBuilder.addStatement("return $N", new Object[]{FloatingFieldModel.this.newName()});
                methodBuilder.endControlFlow();
                methodBuilder.endControlFlow();
            }

            @Override
            public void generateArrayElementAddAtomic(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                arrayFieldModel.checkBounds(methodBuilder);
                methodBuilder.beginControlFlow("while (true)", new Object[0]);
                Class type = Utils.UNSAFE_CLASS;
                methodBuilder.addStatement("$T $N = " + this.wrap(valueBuilder, methodBuilder, "$N.$N($N, (long) $T.$N + (index * (long) $T.$N))"), new Object[]{FloatingFieldModel.this.type, FloatingFieldModel.this.oldName(), valueBuilder.unsafe(), this.getVolatile(), this.field, type, this.arrayBase(), type, this.arrayScale()});
                methodBuilder.addStatement("$T $N = $N + addition", new Object[]{FloatingFieldModel.this.type, FloatingFieldModel.this.newName(), FloatingFieldModel.this.oldName()});
                methodBuilder.beginControlFlow(String.format("if ($N.$N($N, (long) $T.$N + (index * (long) $T.$N), %s, %s))", this.unwrap(methodBuilder, "$N"), this.unwrap(methodBuilder, "$N")), new Object[]{valueBuilder.unsafe(), this.compareAndSwap(), this.field, type, this.arrayBase(), type, this.arrayScale(), FloatingFieldModel.this.oldName(), FloatingFieldModel.this.newName()});
                methodBuilder.addStatement("return $N", new Object[]{FloatingFieldModel.this.newName()});
                methodBuilder.endControlFlow();
                methodBuilder.endControlFlow();
            }

            @Override
            void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addCode(String.format("if ($N(%s) != $N(other.$N())) return false;\n", this.wrap(valueBuilder, methodBuilder, "$N")), new Object[]{FloatingFieldModel.this.toBits(), this.field, FloatingFieldModel.this.toBits(), FloatingFieldModel.this.getOrGetVolatile().getName()});
            }

            @Override
            void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                methodBuilder.addCode(String.format("if ($N(%s) != $N(other.$N(index))) return false;\n", this.wrap(valueBuilder, methodBuilder, "$N[index]")), new Object[]{FloatingFieldModel.this.toBits(), this.field, FloatingFieldModel.this.toBits(), arrayFieldModel.getOrGetVolatile().getName()});
            }
        };
    }

    private String toBits() {
        if (this.type == Float.TYPE) {
            return "java.lang.Float.floatToIntBits";
        }
        return "java.lang.Double.doubleToLongBits";
    }
}

