/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.values;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.values.ArrayFieldModel;
import net.openhft.chronicle.values.IntegerBackedFieldModel;
import net.openhft.chronicle.values.IntegerBackedNativeMemberGenerator;
import net.openhft.chronicle.values.IntegerFieldModel;
import net.openhft.chronicle.values.MemberGenerator;
import net.openhft.chronicle.values.PrimitiveBackedHeapMemberGenerator;
import net.openhft.chronicle.values.RangeImpl;
import net.openhft.chronicle.values.Utils;
import net.openhft.chronicle.values.ValueBuilder;
import net.openhft.chronicle.values.ValueFieldModel;

final class PointerFieldModel
extends IntegerBackedFieldModel {
    private final ValueFieldModel pointedModel;
    final MemberGenerator nativeGenerator;

    PointerFieldModel(ValueFieldModel pointedModel) {
        this.nativeGenerator = new IntegerBackedNativeMemberGenerator(this, this.backend){

            @Override
            void generateFields(ValueBuilder valueBuilder) {
                super.generateFields(valueBuilder);
                PointerFieldModel.this.pointedModel.nativeGenerator().generateFields(valueBuilder);
            }

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
                this.generateFields(valueBuilder);
            }

            @Override
            void finishGet(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address) {
                String addressVariable = PointerFieldModel.this.name + "Address";
                methodBuilder.addStatement("long $N = $N", new Object[]{addressVariable, address});
                methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{addressVariable});
                PointerFieldModel.this.initCachedValue(valueBuilder, methodBuilder, address);
                methodBuilder.addStatement("return $N", new Object[]{PointerFieldModel.this.cachedValue()});
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("return null", new Object[0]);
                methodBuilder.endControlFlow();
            }

            @Override
            String startSet(MethodSpec.Builder methodBuilder) {
                return PointerFieldModel.this.extractAddress(methodBuilder, PointerFieldModel.this.varName());
            }

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                PointerFieldModel.this.genWriteMarshallable(valueBuilder, methodBuilder, address, PointerFieldModel.this.cachedValue());
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                PointerFieldModel.this.genReadMarshallable(valueBuilder, methodBuilder, address, PointerFieldModel.this.cachedValue(), () -> this.backingFieldModel.genSet(valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, "0L"));
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                PointerFieldModel.this.genWriteMarshallable(valueBuilder, methodBuilder, address, PointerFieldModel.this.cachedValue());
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                PointerFieldModel.this.genReadMarshallable(valueBuilder, methodBuilder, address, PointerFieldModel.this.cachedValue(), () -> this.backingFieldModel.genArrayElementSet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE, "0L"));
            }

            @Override
            void generateEquals(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String otherValueVariable = "other" + Utils.capitalize(PointerFieldModel.this.name);
                methodBuilder.addStatement("$T $N = other.$N()", new Object[]{PointerFieldModel.this.type, otherValueVariable, PointerFieldModel.this.getOrGetVolatile().getName()});
                String otherAddress = PointerFieldModel.this.extractAddress(methodBuilder, otherValueVariable);
                String thisAddress = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                methodBuilder.addCode("if ($N != $N) return false;\n", new Object[]{thisAddress, otherAddress});
            }

            @Override
            void generateArrayElementEquals(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String otherValueVariable = "other" + Utils.capitalize(PointerFieldModel.this.name);
                methodBuilder.addStatement("$T $N = other.$N(index)", new Object[]{PointerFieldModel.this.type, otherValueVariable, PointerFieldModel.this.getOrGetVolatile().getName()});
                String otherAddress = PointerFieldModel.this.extractAddress(methodBuilder, otherValueVariable);
                String thisAddress = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                methodBuilder.addCode("if ($N != $N) return false;\n", new Object[]{thisAddress, otherAddress});
            }

            @Override
            String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genGet(valueBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                return String.format("Long.hashCode(%s)", address);
            }

            @Override
            String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                String address = this.backingFieldModel.genArrayElementGet(arrayFieldModel, valueBuilder, methodBuilder, IntegerFieldModel.NORMAL_ACCESS_TYPE);
                return String.format("Long.hashCode(%s)", address);
            }
        };
        this.pointedModel = pointedModel;
    }

    @Override
    void postProcess() {
        super.postProcess();
        this.pointedModel.postProcess();
        this.backend.type = Long.TYPE;
        this.backend.range = RangeImpl.DEFAULT_LONG_RANGE;
        this.backend.postProcess();
    }

    @Override
    void checkState() {
        super.checkState();
        this.pointedModel.checkState();
    }

    private FieldSpec cachedValue() {
        return this.pointedModel.nativeGenerator().cachedValue;
    }

    private void initCachedValue(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address) {
        methodBuilder.addStatement("$N.set($N, $L)", new Object[]{valueBuilder.bytesStoreForPointers(), address, this.pointedModel.sizeInBytes()});
        methodBuilder.addStatement("$N.bytesStore($N, 0, $L)", new Object[]{this.cachedValue(), valueBuilder.bytesStoreForPointers(), this.pointedModel.sizeInBytes()});
    }

    private String extractAddress(MethodSpec.Builder methodBuilder, String value) {
        String addressVariable = value + "Address";
        methodBuilder.addStatement("long $N", new Object[]{addressVariable});
        methodBuilder.beginControlFlow("if ($N != null)", new Object[]{value});
        methodBuilder.beginControlFlow("if (!($N instanceof $T))", new Object[]{value, Byteable.class});
        String message = "\"$N should be instance of $T, \" + $N.getClass() + \" is given\"";
        methodBuilder.addStatement("throw new $T(" + message + ")", new Object[]{IllegalArgumentException.class, this.name, Byteable.class, value});
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$N = (($T) $N).address()", new Object[]{addressVariable, Byteable.class, value});
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("$N = 0L", new Object[]{addressVariable});
        methodBuilder.endControlFlow();
        return addressVariable;
    }

    private void genWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address, Object value) {
        String addressVariable = this.name + "Address";
        methodBuilder.addStatement("long $N = $N", new Object[]{addressVariable, address});
        methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{addressVariable});
        this.initCachedValue(valueBuilder, methodBuilder, address);
        methodBuilder.addStatement("bytes.writeBoolean(true)", new Object[0]);
        methodBuilder.addStatement("$N.writeMarshallable(bytes)", new Object[]{value});
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("bytes.writeBoolean(false)", new Object[0]);
        methodBuilder.endControlFlow();
    }

    private void genReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address, Object value, Runnable setNull) {
        String present = this.name + "Present";
        methodBuilder.addStatement("boolean $N = bytes.readBoolean()", new Object[]{present});
        methodBuilder.beginControlFlow("if ($N)", new Object[]{present});
        String addressVariable = this.name + "Address";
        methodBuilder.addStatement("long $N = $N", new Object[]{addressVariable, address});
        methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{addressVariable});
        this.initCachedValue(valueBuilder, methodBuilder, address);
        methodBuilder.addStatement("$N.readMarshallable(bytes)", new Object[]{value});
        methodBuilder.nextControlFlow("else", new Object[0]);
        methodBuilder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, this.name + " field should be initialized to some pointer when reading non-null value from marshalled bytes"});
        methodBuilder.endControlFlow();
        methodBuilder.nextControlFlow("else", new Object[0]);
        setNull.run();
        methodBuilder.endControlFlow();
    }

    @Override
    MemberGenerator nativeGenerator() {
        return this.nativeGenerator;
    }

    @Override
    MemberGenerator createHeapGenerator() {
        return new PrimitiveBackedHeapMemberGenerator(this, this.backend.type){

            @Override
            void generateFields(ValueBuilder valueBuilder) {
                super.generateFields(valueBuilder);
                PointerFieldModel.this.pointedModel.nativeGenerator().generateFields(valueBuilder);
            }

            @Override
            void generateArrayElementFields(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder) {
                super.generateArrayElementFields(arrayFieldModel, valueBuilder);
                PointerFieldModel.this.pointedModel.nativeGenerator().generateArrayElementFields(arrayFieldModel, valueBuilder);
            }

            @Override
            String wrap(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String rawStoredValue) {
                String result = PointerFieldModel.this.name + "Result";
                methodBuilder.addStatement("$T $N", new Object[]{PointerFieldModel.this.type, result});
                methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{rawStoredValue});
                PointerFieldModel.this.initCachedValue(valueBuilder, methodBuilder, rawStoredValue);
                methodBuilder.addStatement("$N = $N", new Object[]{result, PointerFieldModel.this.cachedValue()});
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("$N = null", new Object[]{result});
                methodBuilder.endControlFlow();
                return result;
            }

            @Override
            String unwrap(MethodSpec.Builder methodBuilder, String inputValue) {
                return PointerFieldModel.this.extractAddress(methodBuilder, inputValue);
            }

            private void genWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address) {
                String addressVariable = PointerFieldModel.this.name + "Address";
                methodBuilder.addStatement("long $N = $N", new Object[]{addressVariable, address});
                methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{addressVariable});
                PointerFieldModel.this.initCachedValue(valueBuilder, methodBuilder, addressVariable);
                methodBuilder.addStatement("bytes.writeBoolean(true)", new Object[0]);
                methodBuilder.addStatement("$N.writeMarshallable(bytes)", new Object[]{PointerFieldModel.this.cachedValue()});
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("bytes.writeBoolean(false)", new Object[0]);
                methodBuilder.endControlFlow();
            }

            @Override
            void generateWriteMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.genWriteMarshallable(valueBuilder, methodBuilder, this.field.name);
            }

            @Override
            void generateArrayElementWriteMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.genWriteMarshallable(valueBuilder, methodBuilder, this.field.name + "[index]");
            }

            private void genReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder, String address, Runnable setNull) {
                String present = PointerFieldModel.this.name + "Present";
                methodBuilder.addStatement("boolean $N = bytes.readBoolean()", new Object[]{present});
                methodBuilder.beginControlFlow("if ($N)", new Object[]{present});
                String addressVariable = PointerFieldModel.this.name + "Address";
                methodBuilder.addStatement("long $N = $N", new Object[]{addressVariable, address});
                methodBuilder.beginControlFlow("if ($N != 0)", new Object[]{addressVariable});
                PointerFieldModel.this.initCachedValue(valueBuilder, methodBuilder, addressVariable);
                methodBuilder.addStatement("$N.readMarshallable(bytes)", new Object[]{PointerFieldModel.this.cachedValue()});
                methodBuilder.nextControlFlow("else", new Object[0]);
                methodBuilder.addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, PointerFieldModel.this.name + " field should be initialized to some pointer when reading non-null value from marshalled bytes"});
                methodBuilder.endControlFlow();
                methodBuilder.nextControlFlow("else", new Object[0]);
                setNull.run();
                methodBuilder.endControlFlow();
            }

            @Override
            void generateReadMarshallable(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.genReadMarshallable(valueBuilder, methodBuilder, this.field.name, () -> methodBuilder.addStatement("$N = 0L", new Object[]{this.field}));
            }

            @Override
            void generateArrayElementReadMarshallable(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                this.genReadMarshallable(valueBuilder, methodBuilder, this.field.name + "[index]", () -> methodBuilder.addStatement("$N[index] = 0L", new Object[]{this.field}));
            }

            @Override
            String generateHashCode(ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return String.format("Long.hashCode(%s)", this.field.name);
            }

            @Override
            String generateArrayElementHashCode(ArrayFieldModel arrayFieldModel, ValueBuilder valueBuilder, MethodSpec.Builder methodBuilder) {
                return String.format("Long.hashCode(%s[index])", this.field.name);
            }
        };
    }
}

