/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.Nullable;

public class TextReadDocumentContext
implements ReadDocumentContext {
    public static final BytesStore MSG_SEP = BytesStore.from((CharSequence)"---");
    @Nullable
    protected AbstractWire wire;
    protected boolean present;
    protected boolean notComplete;
    private boolean metaData;
    private long readPosition;
    private long readLimit;

    public TextReadDocumentContext(@Nullable AbstractWire wire) {
        this.wire = wire;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void metaData(boolean metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void closeReadPosition(long readPosition) {
        this.readPosition = readPosition;
    }

    @Override
    public void closeReadLimit(long readLimit) {
        this.readLimit = readLimit;
    }

    @Override
    @Nullable
    public Wire wire() {
        return this.wire;
    }

    public void close() {
        long readLimit = this.readLimit;
        long readPosition = this.readPosition;
        AbstractWire wire0 = this.wire;
        wire0.bytes.readLimit(readLimit);
        wire0.bytes.readPosition(readPosition);
        this.present = false;
    }

    public static void consumeToEndOfMessage(Bytes<?> bytes) {
        while (bytes.readRemaining() > 0L) {
            while (bytes.readRemaining() > 0L && bytes.readUnsignedByte() >= 32) {
            }
            if (!TextReadDocumentContext.isEndOfMessage(bytes)) continue;
            break;
        }
    }

    public static boolean isEndOfMessage(Bytes<?> bytes) {
        return bytes.startsWith(MSG_SEP) && bytes.peekUnsignedByte(bytes.readPosition() + 3L) <= 32;
    }

    @Override
    public void start() {
        this.wire.getValueOut().resetBetweenDocuments();
        Bytes<?> bytes = this.wire.bytes();
        this.present = false;
        this.wire.consumePadding();
        if (TextReadDocumentContext.isEndOfMessage(bytes)) {
            bytes.readSkip(3L);
            this.wire.consumePadding();
        }
        if (bytes.readRemaining() < 1L) {
            this.readLimit = this.readPosition = bytes.readLimit();
            this.notComplete = false;
            return;
        }
        long position = bytes.readPosition();
        TextReadDocumentContext.consumeToEndOfMessage(bytes);
        this.metaData = false;
        this.readLimit = bytes.readLimit();
        this.readPosition = bytes.readPosition();
        bytes.readLimit(bytes.readPosition());
        bytes.readPosition(position);
        this.present = true;
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }

    public String toString() {
        return this.wire.toString();
    }
}

