/*
 * Copyright 2014 Higher Frequency Trading
 *
 * http://www.higherfrequencytrading.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.openhft.chronicle.tcp;

import java.net.InetSocketAddress;

public class AddressProviders {

    public static final AddressProvider single(InetSocketAddress address) {
        return new Single(address);
    }

    // *************************************************************************
    //
    // *************************************************************************

    private static final class Single implements AddressProvider {
        private final InetSocketAddress address;

        public Single(InetSocketAddress address) {
            this.address = address;
        }

        @Override
        public InetSocketAddress get() {
            return this.address;
        }
    }
}
