/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.time.LocalTime;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import net.serenitybdd.screenplay.ensure.TimeEnsure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0004B?\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\n\u00a2\u0006\u0002\u0010\u000bJC\u0010\u000e\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0002JC\u0010\u0013\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u00120\u000f2\u0006\u0010\u0012\u001a\u00020\u0002J\b\u0010\u0014\u001a\u00020\u0000H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016J \u0010\u0016\u001a\u00020\u00002\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lnet/serenitybdd/screenplay/ensure/TimeEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "Ljava/time/LocalTime;", "value", "(Ljava/time/LocalTime;)V", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isAfter", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "isBefore", "not", "silently", "usingComparator", "Companion", "serenity-ensure"})
public final class TimeEnsure
extends ComparableEnsure<LocalTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Actor, LocalTime> value;
    @NotNull
    private static final Expectation<Function1<Actor, LocalTime>, LocalTime> BEFORE = ExpectationKt.expectThatActualIs("before", Companion.BEFORE.1.INSTANCE);
    @NotNull
    private static final Expectation<Function1<Actor, LocalTime>, LocalTime> AFTER = ExpectationKt.expectThatActualIs("after", Companion.AFTER.1.INSTANCE);

    public TimeEnsure(@NotNull Function1<? super Actor, LocalTime> value, @NotNull Comparator<LocalTime> comparator) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        super(value, comparator, null, 4, null);
        this.value = value;
    }

    @Override
    @NotNull
    public Function1<Actor, LocalTime> getValue() {
        return this.value;
    }

    public TimeEnsure(@Nullable LocalTime value) {
        this((Function1<? super Actor, LocalTime>)new KnownValue<LocalTime>(value, String.valueOf(value)), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalTime>, LocalTime> isBefore(@NotNull LocalTime expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalTime>, LocalTime>(this.getValue(), BEFORE, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalTime>, LocalTime> isAfter(@NotNull LocalTime expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalTime>, LocalTime>(this.getValue(), AFTER, expected, this.isNegated(), null, null, 48, null);
    }

    @Override
    @NotNull
    public TimeEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.TimeEnsure");
        return (TimeEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public TimeEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        Intrinsics.checkNotNull((Object)commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.TimeEnsure");
        return (TimeEnsure)commonEnsure;
    }

    @NotNull
    public TimeEnsure usingComparator(@NotNull Comparator<LocalTime> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        return new TimeEnsure(this.getValue(), comparator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RY\u0010\u0003\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eRY\u0010\u000f\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lnet/serenitybdd/screenplay/ensure/TimeEnsure$Companion;", "", "()V", "AFTER", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Ljava/time/LocalTime;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "Lkotlin/ParameterName;", "name", "actual", "expected", "getAFTER", "()Lnet/serenitybdd/screenplay/ensure/Expectation;", "BEFORE", "getBEFORE", "serenity-ensure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalTime>, LocalTime> getBEFORE() {
            return BEFORE;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalTime>, LocalTime> getAFTER() {
            return AFTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

