/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.finder;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.serenitybdd.junit.finder.TestFinder;
import net.serenitybdd.junit.runners.DataDrivenAnnotations;
import org.junit.runners.model.TestClass;

public class DataDrivenTestFinder
extends TestFinder {
    public DataDrivenTestFinder(String rootPackage) {
        super(rootPackage);
    }

    @Override
    public List<Class<?>> getClasses() {
        return this.sorted(Lists.newArrayList(this.getDataDrivenTestClasses()));
    }

    @Override
    public int countTestMethods() {
        int totalTestMethods = 0;
        for (Class<?> testClass : this.getDataDrivenTestClasses()) {
            try {
                totalTestMethods += DataDrivenAnnotations.forClass(new TestClass(testClass)).countDataEntries();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to read test data for " + testClass);
            }
        }
        return totalTestMethods;
    }
}

