/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.listeners;

import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.logging.LoggingLevel;
import net.thucydides.model.statistics.TestCount;
import net.thucydides.model.steps.StepListenerAdapter;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCountListener
extends StepListenerAdapter {
    private final Logger logger;
    private final EnvironmentVariables environmentVariables;
    private final TestCount testCount;
    private final boolean reportTestCount;

    protected TestCountListener(EnvironmentVariables environmentVariables, Logger logger, TestCount testCount) {
        this.logger = logger;
        this.environmentVariables = environmentVariables;
        this.testCount = testCount;
        this.reportTestCount = ThucydidesSystemProperty.SERENITY_DISPLAY_TEST_NUMBERS.booleanFrom(environmentVariables, Boolean.valueOf(false));
    }

    public TestCountListener(EnvironmentVariables environmentVariables, TestCount testCount) {
        this(environmentVariables, LoggerFactory.getLogger((String)""), testCount);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void testStarted(String description) {
        int currentTestCount = this.testCount.getNextTest();
        if (this.reportTestCount && LoggingLevel.definedIn((EnvironmentVariables)this.environmentVariables).isAtLeast(LoggingLevel.VERBOSE)) {
            this.getLogger().info("TEST NUMBER: {}", (Object)currentTestCount);
        }
    }

    public void testStarted(String description, String id) {
        this.testStarted(description);
    }
}

