/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit5.extensions;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.serenitybdd.junit5.extensions.TemporaryFolder;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class TemporaryFolderExtension
implements AfterEachCallback,
TestInstancePostProcessor,
ParameterResolver {
    private final Collection<TemporaryFolder> tempFolders = new ArrayList<TemporaryFolder>();

    private TemporaryFolder createTempFolder() {
        TemporaryFolder result = new TemporaryFolder();
        result.prepare();
        this.tempFolders.add(result);
        return result;
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.tempFolders.forEach(TemporaryFolder::cleanUp);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == TemporaryFolder.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.createTempFolder();
    }

    public void postProcessTestInstance(Object o, ExtensionContext extensionContext) throws Exception {
        Optional testInstance = extensionContext.getTestInstance();
        Arrays.stream(testInstance.getClass().getDeclaredFields()).filter(field -> field.getType() == TemporaryFolder.class).forEach(field -> this.injectTemporaryFolder(testInstance, (Field)field));
    }

    private void injectTemporaryFolder(Object instance, Field field) {
        field.setAccessible(true);
        try {
            field.set(instance, this.createTempFolder());
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }
}

