/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.adapters.junit5;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import net.thucydides.model.adapters.TestStrategyAdapter;
import net.thucydides.model.adapters.junit5.JUnit5Strategy;
import net.thucydides.model.domain.TestTag;

public class JUnit5Adapter
implements TestStrategyAdapter {
    private final JUnit5Strategy jUnit5Strategy = new JUnit5Strategy();

    public boolean isTestClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.jUnit5Strategy.isTestClass(testClass);
    }

    public boolean isTestMethod(Method method) {
        if (method == null) {
            return false;
        }
        return this.jUnit5Strategy.isTestMethod(method);
    }

    public boolean isTestSetupMethod(Method method) {
        if (method == null) {
            return false;
        }
        return this.jUnit5Strategy.isTestSetupMethod(method);
    }

    public boolean isSerenityTestCase(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.jUnit5Strategy.isSerenityTestCase(testClass);
    }

    public boolean isAssumptionViolatedException(Throwable throwable) {
        return this.jUnit5Strategy.isAssumptionViolatedException(throwable);
    }

    public boolean isATaggableClass(Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.jUnit5Strategy.isATaggableClass(testClass);
    }

    public boolean isIgnored(Method method) {
        if (method == null) {
            return false;
        }
        return this.jUnit5Strategy.isIgnored(method);
    }

    public Optional<String> getTitleAnnotation(Method testMethod) {
        return this.jUnit5Strategy.getTitleAnnotation(testMethod);
    }

    public List<TestTag> getTagsFor(Method testMethod) {
        return this.jUnit5Strategy.getTagsFor(testMethod);
    }

    public Double priority() {
        return 5.7;
    }
}

