/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.reports.ReportGenerationFailedError;

class CopyProjectSpecificResourcesTask
extends HtmlReporter
implements ReportingTask {
    private static final String DEFAULT_ASSETS_DIRECTORIES = "src/test/resources/assets";

    CopyProjectSpecificResourcesTask() {
    }

    @Override
    public void generateReports() throws IOException {
        if (!Files.exists(this.assetSourcePath(), new LinkOption[0])) {
            return;
        }
        Files.createDirectories(this.assetsDestinationDirectory(), new FileAttribute[0]);
        ((Stream)Files.list(this.assetSourcePath()).filter(this::notCopied).parallel()).forEach(this::copyToTarget);
        Files.list(this.assetSourcePath()).filter(this::notCopied).forEach(this::copyToTarget);
    }

    @Override
    public String reportName() {
        return "CopyProjectSpecificResourcesTask";
    }

    private boolean notCopied(Path imageFile) {
        return !this.transferred(imageFile).toFile().exists();
    }

    private void copyToTarget(Path imageFile) {
        try {
            if (this.notCopied(imageFile)) {
                Files.copy(imageFile, this.transferred(imageFile), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (FileSystemException fileSystemException) {
        }
        catch (IOException e) {
            throw new ReportGenerationFailedError(e.getMessage(), (Throwable)e);
        }
    }

    private Path transferred(Path imageFile) {
        return this.assetsDestinationDirectory().resolve(imageFile.getFileName());
    }

    private Path assetSourcePath() {
        Path projectDirectory = Optional.ofNullable(ModelInfrastructure.getConfiguration().getProjectDirectory()).orElse(Paths.get("", new String[0]));
        return projectDirectory.resolve(ThucydidesSystemProperty.REPORT_ASSETS_DIRECTORY.from(this.getEnvironmentVariables(), DEFAULT_ASSETS_DIRECTORIES));
    }

    private Path assetsDestinationDirectory() {
        return this.getOutputDirectory().toPath().resolve("assets");
    }
}

