/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.serenitybdd.model.time.Stopwatch;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.model.domain.ReportNamer;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.util.EnvironmentVariables;

public class TextSummaryReportTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_SUMMARY_TEMPLATE_PATH = "freemarker/text-summary.ftl";
    private static final String TEST_SUMMARY_REPORT_NAME = "summary.txt";
    protected final ReportNameProvider reportNameProvider;
    private final TestOutcomes testOutcomes;

    public TextSummaryReportTask(FreemarkerContext context, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes) {
        super(context, environmentVariables, outputDirectory);
        this.testOutcomes = testOutcomes;
        this.reportNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportNamer.forReportType((ReportType)ReportType.HTML));
    }

    @Override
    public void generateReports() throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(this.testOutcomes, this.reportNameProvider, true);
        Stopwatch stopwatch = Stopwatch.started();
        this.generateReportPage(context, TEST_SUMMARY_TEMPLATE_PATH, TEST_SUMMARY_REPORT_NAME);
        LOGGER.trace("Summary report generated: {} ms", (Object)stopwatch.stop());
    }

    @Override
    public String reportName() {
        return TEST_SUMMARY_REPORT_NAME;
    }

    public String toString() {
        return "Test Summary Report";
    }
}

