/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.winstone.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class EmbedMojo
extends AbstractMojo {
    private File outputDirectory;
    private String filename;
    private File warFile;
    private Properties cmdLineOptions;
    protected MavenProject project;
    protected ArtifactFactory factory;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver resolver;
    protected List remoteRepositories;
    private byte[] buffer_ = new byte[1024];

    public void execute() throws MojoExecutionException {
        if (!"war".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"work only for packaging == 'war'");
            return;
        }
        try {
            File f = this.outputDirectory;
            if (!f.exists()) {
                f.mkdirs();
            }
            this.embed();
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc.getMessage(), exc);
        }
    }

    protected File findWinstoneJar() throws Exception {
        File back = null;
        Plugin me = (Plugin)this.project.getBuild().getPluginsAsMap().get("net.sf.alchim:winstone-maven-plugin");
        Iterator it = me.getDependencies().iterator();
        while (it.hasNext() && back == null) {
            Dependency dep = (Dependency)it.next();
            if (dep.getArtifactId().indexOf("winstone") <= -1) continue;
            Artifact artifact = this.factory.createArtifactWithClassifier(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier());
            back = this.selectWinstoneJar(artifact);
        }
        if (back == null) {
            Artifact artifact = this.factory.createArtifactWithClassifier("net.sourceforge.winstone", "winstone", "0.9.10", "jar", "");
            back = this.selectWinstoneJar(artifact);
        }
        if (back == null) {
            throw new MojoFailureException("winstone artifact not found, please declare winstone artifact in plugin's dependencies");
        }
        return back;
    }

    private File selectWinstoneJar(Artifact artifact) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        File found = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (!found.exists()) {
            return null;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void embed() throws Exception {
        File outputFile = new File(this.outputDirectory, this.filename);
        JarOutputStream zos = new JarOutputStream(new FileOutputStream(outputFile));
        try {
            this.putWinstone(zos);
            this.putWarFile(zos);
            this.putCmdLineOptions(zos);
        }
        finally {
            this.getLog().info((CharSequence)(outputFile + " created"));
            this.close(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWinstone(JarOutputStream zos) throws Exception {
        File file = this.findWinstoneJar();
        this.getLog().info((CharSequence)("use winstone file: " + file.getName()));
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry ientry = entries.nextElement();
                this.getLog().debug((CharSequence)("copying file: " + ientry.getName()));
                JarEntry oentry = (JarEntry)ientry.clone();
                zos.putNextEntry(oentry);
                this.copyInto(jarFile.getInputStream(ientry), zos);
                zos.closeEntry();
            }
        }
        finally {
            this.close(jarFile);
        }
    }

    private void putWarFile(JarOutputStream zos) throws Exception {
        this.getLog().info((CharSequence)("use war file: " + this.warFile.getName()));
        JarEntry oentry = new JarEntry("embedded.war");
        zos.putNextEntry(oentry);
        this.copyInto(new FileInputStream(this.warFile), zos);
        zos.closeEntry();
    }

    private void putCmdLineOptions(JarOutputStream zos) throws Exception {
        if (this.cmdLineOptions == null || ((Hashtable)this.cmdLineOptions).size() < 1) {
            this.getLog().info((CharSequence)"no cmd line options to embed");
            return;
        }
        JarEntry oentry = new JarEntry("embedded.properties");
        zos.putNextEntry(oentry);
        this.cmdLineOptions.store(zos, "embedded command line options for winstone");
        zos.closeEntry();
    }

    private void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException exc) {
                this.getLog().warn((Throwable)exc);
            }
        }
    }

    private void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException exc) {
                this.getLog().warn((Throwable)exc);
            }
        }
    }

    private void close(JarFile stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException exc) {
                this.getLog().warn((Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyInto(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            while ((len = in.read(this.buffer_)) >= 0) {
                out.write(this.buffer_, 0, len);
            }
        }
        finally {
            this.close(in);
        }
    }
}

