/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationMirror;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationTypeDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationTypeElementDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedClassDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedConstructorDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedEnumConstantDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedEnumDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedExecutableDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedFieldDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedInterfaceDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedMemberDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedMethodDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedPackageDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedParameterDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedTypeParameterDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationDecorator
implements DeclarationVisitor {
    private Declaration decoratedDeclaration;

    protected static DeclarationDecorator getInstance() {
        String decoratorClassname = System.getProperty(DeclarationDecorator.class.getName());
        if (decoratorClassname != null) {
            try {
                return (DeclarationDecorator)Class.forName(decoratorClassname).newInstance();
            }
            catch (Exception e) {
                System.getProperties().remove(DeclarationDecorator.class.getName());
                e.printStackTrace(System.err);
                System.err.println("Unable to lookup DeclarationDecorator.  Using default decorator...");
            }
        }
        return new DeclarationDecorator();
    }

    public static <D extends Declaration> D decorate(D declaration) {
        if (declaration == null) {
            return null;
        }
        DeclarationDecorator decorator = DeclarationDecorator.getInstance();
        declaration.accept((DeclarationVisitor)decorator);
        return (D)decorator.getDecoratedDeclaration();
    }

    public static <D extends Declaration> Collection<D> decorate(Collection<D> declarations) {
        if (declarations == null) {
            return null;
        }
        DeclarationDecorator decorator = DeclarationDecorator.getInstance();
        ArrayList<Declaration> decls = new ArrayList<Declaration>(declarations.size());
        for (Declaration declaration : declarations) {
            declaration.accept((DeclarationVisitor)decorator);
            decls.add(decorator.getDecoratedDeclaration());
        }
        return decls;
    }

    public static Collection<AnnotationMirror> decorateAnnotationMirrors(Collection<AnnotationMirror> annotationMirrors) {
        if (annotationMirrors == null) {
            return null;
        }
        DeclarationDecorator decorator = DeclarationDecorator.getInstance();
        ArrayList<AnnotationMirror> mirrors = new ArrayList<AnnotationMirror>(annotationMirrors.size());
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!(annotationMirror instanceof DecoratedAnnotationMirror)) {
                annotationMirror = decorator.decorate(annotationMirror);
            }
            mirrors.add(annotationMirror);
        }
        return mirrors;
    }

    public Declaration getDecoratedDeclaration() {
        return this.decoratedDeclaration;
    }

    public void visitDeclaration(Declaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedDeclaration ? declaration : new DecoratedDeclaration(declaration);
    }

    public void visitPackageDeclaration(PackageDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedPackageDeclaration ? declaration : new DecoratedPackageDeclaration(declaration);
    }

    public void visitMemberDeclaration(MemberDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedMemberDeclaration ? declaration : new DecoratedMemberDeclaration(declaration);
    }

    public void visitTypeDeclaration(TypeDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedTypeDeclaration ? declaration : new DecoratedTypeDeclaration(declaration);
    }

    public void visitClassDeclaration(ClassDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedClassDeclaration ? declaration : new DecoratedClassDeclaration(declaration);
    }

    public void visitEnumDeclaration(EnumDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedEnumDeclaration ? declaration : new DecoratedEnumDeclaration(declaration);
    }

    public void visitInterfaceDeclaration(InterfaceDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedInterfaceDeclaration ? declaration : new DecoratedInterfaceDeclaration(declaration);
    }

    public void visitAnnotationTypeDeclaration(AnnotationTypeDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedAnnotationTypeDeclaration ? declaration : new DecoratedAnnotationTypeDeclaration(declaration);
    }

    public void visitFieldDeclaration(FieldDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedFieldDeclaration ? declaration : new DecoratedFieldDeclaration(declaration);
    }

    public void visitEnumConstantDeclaration(EnumConstantDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedEnumConstantDeclaration ? declaration : new DecoratedEnumConstantDeclaration((FieldDeclaration)declaration);
    }

    public void visitExecutableDeclaration(ExecutableDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedExecutableDeclaration ? declaration : new DecoratedExecutableDeclaration(declaration);
    }

    public void visitConstructorDeclaration(ConstructorDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedConstructorDeclaration ? declaration : new DecoratedConstructorDeclaration(declaration);
    }

    public void visitMethodDeclaration(MethodDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedMethodDeclaration ? declaration : new DecoratedMethodDeclaration(declaration);
    }

    public void visitAnnotationTypeElementDeclaration(AnnotationTypeElementDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedAnnotationTypeElementDeclaration ? declaration : new DecoratedAnnotationTypeElementDeclaration(declaration);
    }

    public void visitParameterDeclaration(ParameterDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedParameterDeclaration ? declaration : new DecoratedParameterDeclaration(declaration);
    }

    public void visitTypeParameterDeclaration(TypeParameterDeclaration declaration) {
        this.decoratedDeclaration = declaration instanceof DecoratedTypeParameterDeclaration ? declaration : new DecoratedTypeParameterDeclaration(declaration);
    }

    public DecoratedAnnotationMirror decorate(AnnotationMirror annotationMirror) {
        return new DecoratedAnnotationMirror(annotationMirror);
    }
}

