/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations;

import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.type.WildcardType;
import com.sun.mirror.util.TypeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jelly.apt.decorations.type.DecoratedAnnotationType;
import net.sf.jelly.apt.decorations.type.DecoratedArrayType;
import net.sf.jelly.apt.decorations.type.DecoratedClassType;
import net.sf.jelly.apt.decorations.type.DecoratedDeclaredType;
import net.sf.jelly.apt.decorations.type.DecoratedEnumType;
import net.sf.jelly.apt.decorations.type.DecoratedInterfaceType;
import net.sf.jelly.apt.decorations.type.DecoratedPrimitiveType;
import net.sf.jelly.apt.decorations.type.DecoratedReferenceType;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.decorations.type.DecoratedTypeVariable;
import net.sf.jelly.apt.decorations.type.DecoratedVoidType;
import net.sf.jelly.apt.decorations.type.DecoratedWildcardType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMirrorDecorator
implements TypeVisitor {
    private TypeMirror decoratedTypeMirror;

    protected static TypeMirrorDecorator getInstance() {
        String decoratorClassname = System.getProperty(TypeMirrorDecorator.class.getName());
        if (decoratorClassname != null) {
            try {
                return (TypeMirrorDecorator)Class.forName(decoratorClassname).newInstance();
            }
            catch (Exception e) {
                System.getProperties().remove(TypeMirrorDecorator.class.getName());
                e.printStackTrace(System.err);
                System.err.println("Unable to lookup TypeMirrorDecorator.  Using default decorator...");
            }
        }
        return new TypeMirrorDecorator();
    }

    public static <T extends TypeMirror> T decorate(T typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        TypeMirrorDecorator decorator = TypeMirrorDecorator.getInstance();
        typeMirror.accept((TypeVisitor)decorator);
        return (T)decorator.getDecoratedTypeMirror();
    }

    public static <T extends TypeMirror> Collection<T> decorate(Collection<T> typeMirrors) {
        if (typeMirrors == null) {
            return null;
        }
        ArrayList<TypeMirror> mirrors = new ArrayList<TypeMirror>(typeMirrors.size());
        TypeMirrorDecorator decorator = TypeMirrorDecorator.getInstance();
        for (TypeMirror mirror : typeMirrors) {
            mirror.accept((TypeVisitor)decorator);
            mirrors.add(decorator.getDecoratedTypeMirror());
        }
        return mirrors;
    }

    public TypeMirror getDecoratedTypeMirror() {
        return this.decoratedTypeMirror;
    }

    public void visitTypeMirror(TypeMirror typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedTypeMirror ? typeMirror : new DecoratedTypeMirror(typeMirror);
    }

    public void visitPrimitiveType(PrimitiveType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedPrimitiveType ? typeMirror : new DecoratedPrimitiveType(typeMirror);
    }

    public void visitVoidType(VoidType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedVoidType ? typeMirror : new DecoratedVoidType(typeMirror);
    }

    public void visitReferenceType(ReferenceType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedReferenceType ? typeMirror : new DecoratedReferenceType(typeMirror);
    }

    public void visitDeclaredType(DeclaredType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedDeclaredType ? typeMirror : new DecoratedDeclaredType(typeMirror);
    }

    public void visitClassType(ClassType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedClassType ? typeMirror : new DecoratedClassType(typeMirror);
    }

    public void visitEnumType(EnumType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedEnumType ? typeMirror : new DecoratedEnumType(typeMirror);
    }

    public void visitInterfaceType(InterfaceType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedInterfaceType ? typeMirror : new DecoratedInterfaceType(typeMirror);
    }

    public void visitAnnotationType(AnnotationType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedAnnotationType ? typeMirror : new DecoratedAnnotationType(typeMirror);
    }

    public void visitArrayType(ArrayType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedArrayType ? typeMirror : new DecoratedArrayType(typeMirror);
    }

    public void visitTypeVariable(TypeVariable typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedTypeVariable ? typeMirror : new DecoratedTypeVariable(typeMirror);
    }

    public void visitWildcardType(WildcardType typeMirror) {
        this.decoratedTypeMirror = typeMirror instanceof DecoratedWildcardType ? typeMirror : new DecoratedWildcardType(typeMirror);
    }
}

