/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SimpleTypeVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInvocationHandler
implements InvocationHandler {
    private final Class annotationType;
    private final DecoratedAnnotationMirror annotationMirror;

    public <A extends Annotation> AnnotationInvocationHandler(Class<A> annotationType, DecoratedAnnotationMirror annotationMirror) {
        this.annotationType = annotationType;
        this.annotationMirror = annotationMirror;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int paramLength = method.getParameterTypes().length;
        if ("equals".equals(methodName) && paramLength == 1) {
            return false;
        }
        if ("hashCode".equals(methodName) && paramLength == 0) {
            return this.hashCode();
        }
        if ("annotationType".equals(methodName) && paramLength == 0) {
            return this.annotationType;
        }
        if ("toString".equals(methodName) && paramLength == 0) {
            return "Proxy invocation handler for " + this.annotationType.getName();
        }
        Map<String, Object> allElementValues = this.annotationMirror.getAllElementValues();
        if (allElementValues.containsKey(methodName)) {
            Object value = allElementValues.get(methodName);
            Class<?> realValueType = method.getReturnType();
            return this.getRealValue(value, realValueType);
        }
        return null;
    }

    protected Object getRealValue(Object value, Class realValueType) {
        Object[] realValue;
        if (value instanceof TypeMirror) {
            try {
                realValue = this.loadClass((TypeMirror)value);
            }
            catch (ClassNotFoundException e) {
                throw new MirroredTypeException((TypeMirror)value);
            }
        }
        if (value instanceof EnumConstantDeclaration) {
            Class enumClass;
            EnumConstantDeclaration constant = (EnumConstantDeclaration)value;
            EnumDeclaration declaringType = constant.getDeclaringType();
            try {
                enumClass = this.loadClass(this.getLoadableFQN((TypeDeclaration)declaringType));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Unable to load the enum class " + declaringType.getQualifiedName() + " to create the instance of " + this.annotationType.getName() + " declared at " + this.annotationMirror.getPosition());
            }
            realValue = Enum.valueOf(enumClass, constant.getSimpleName());
        } else if (value instanceof AnnotationMirror) {
            DecoratedAnnotationMirror childMirror = new DecoratedAnnotationMirror((AnnotationMirror)value);
            realValue = Proxy.newProxyInstance(this.annotationType.getClassLoader(), new Class[]{realValueType}, (InvocationHandler)new AnnotationInvocationHandler(realValueType, childMirror));
        } else if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!realValueType.isArray()) {
                throw new IllegalArgumentException("Expected the real value type to be an array.  Actual: " + realValueType.getName());
            }
            Class<?> componentType = realValueType.getComponentType();
            Object[] valueArray = (Object[])Array.newInstance(componentType, values.size());
            try {
                int index = 0;
                for (AnnotationValue annotationValue : values) {
                    valueArray[index] = this.getRealValue(annotationValue.getValue(), componentType);
                    ++index;
                }
            }
            catch (MirroredTypeException e) {
                if (Class.class.isAssignableFrom(componentType)) {
                    ArrayList<TypeMirror> typeMirrors = new ArrayList<TypeMirror>(values.size());
                    for (AnnotationValue annotationValue : values) {
                        typeMirrors.add((TypeMirror)annotationValue.getValue());
                    }
                    throw new MirroredTypesException(typeMirrors);
                }
                throw e;
            }
            realValue = valueArray;
        } else {
            realValue = value;
        }
        return realValue;
    }

    protected Class loadClass(TypeMirror typeMirror) throws ClassNotFoundException {
        final boolean[] isPrimitive = new boolean[]{false};
        final String[] fqn = new String[]{null};
        typeMirror.accept((TypeVisitor)new SimpleTypeVisitor(){

            public void visitPrimitiveType(PrimitiveType primitiveType) {
                isPrimitive[0] = true;
                switch (primitiveType.getKind()) {
                    case BOOLEAN: {
                        fqn[0] = Boolean.class.getName();
                        break;
                    }
                    case BYTE: {
                        fqn[0] = Byte.class.getName();
                        break;
                    }
                    case CHAR: {
                        fqn[0] = Character.class.getName();
                        break;
                    }
                    case DOUBLE: {
                        fqn[0] = Double.class.getName();
                        break;
                    }
                    case FLOAT: {
                        fqn[0] = Float.class.getName();
                        break;
                    }
                    case INT: {
                        fqn[0] = Integer.class.getName();
                        break;
                    }
                    case LONG: {
                        fqn[0] = Long.class.getName();
                        break;
                    }
                    case SHORT: {
                        fqn[0] = Short.class.getName();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown kind: " + primitiveType);
                    }
                }
            }

            public void visitVoidType(VoidType voidType) {
                isPrimitive[0] = true;
                fqn[0] = Void.class.getName();
            }

            public void visitDeclaredType(DeclaredType declaredType) {
                TypeDeclaration declaration = declaredType.getDeclaration();
                if (declaration != null) {
                    fqn[0] = AnnotationInvocationHandler.this.getLoadableFQN(declaration);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getComponentType().accept((TypeVisitor)this);
                fqn[0] = fqn[0] + "[]";
            }
        });
        if (fqn[0] != null) {
            Class clazz = this.loadClass(fqn[0]);
            if (isPrimitive[0]) {
                try {
                    Field field = clazz.getField("TYPE");
                    clazz = (Class)field.get(null);
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Unable to load the primitive type " + typeMirror, e);
                }
            }
            return clazz;
        }
        throw new ClassNotFoundException("Class not found: " + typeMirror);
    }

    protected String getLoadableFQN(TypeDeclaration declaration) {
        StringBuilder className = new StringBuilder();
        TypeDeclaration declaringType = declaration.getDeclaringType();
        while (declaringType != null) {
            className.insert(0, "$" + declaration.getSimpleName());
            declaration = declaringType;
            declaringType = declaration.getDeclaringType();
        }
        className.insert(0, declaration.getQualifiedName());
        return className.toString();
    }

    protected Class loadClass(String qualifiedName) throws ClassNotFoundException {
        return Class.forName(qualifiedName, true, this.annotationType.getClassLoader());
    }
}

