/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.util.DeclarationVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedMemberDeclaration;
import net.sf.jelly.apt.decorations.declaration.DecoratedParameterDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratedExecutableDeclaration
extends DecoratedMemberDeclaration
implements ExecutableDeclaration {
    protected HashMap<String, String> throwsComments = new HashMap();
    protected HashMap<String, String> paramsComments;

    public DecoratedExecutableDeclaration(ExecutableDeclaration delegate) {
        super((MemberDeclaration)delegate);
        ArrayList allThrowsComments = new ArrayList();
        if (this.getJavaDoc().get("throws") != null) {
            allThrowsComments.addAll((Collection)this.getJavaDoc().get("throws"));
        }
        if (this.getJavaDoc().get("exception") != null) {
            allThrowsComments.addAll((Collection)this.getJavaDoc().get("exception"));
        }
        for (String throwsDoc : allThrowsComments) {
            int spaceIndex = throwsDoc.indexOf(32);
            if (spaceIndex == -1) {
                spaceIndex = throwsDoc.length();
            }
            String exception = throwsDoc.substring(0, spaceIndex);
            String throwsComment = "";
            if (spaceIndex + 1 < throwsDoc.length()) {
                throwsComment = throwsDoc.substring(spaceIndex + 1);
            }
            this.throwsComments.put(exception, throwsComment);
        }
        this.paramsComments = DecoratedExecutableDeclaration.parseParamComments(this.getJavaDoc());
    }

    protected static HashMap<String, String> parseParamComments(JavaDoc jd) {
        HashMap<String, String> paramComments = new HashMap<String, String>();
        if (jd.get("param") != null) {
            for (String paramDoc : (JavaDoc.JavaDocTagList)jd.get("param")) {
                int spaceIndex = (paramDoc = paramDoc.replaceAll("\\s", " ")).indexOf(32);
                if (spaceIndex == -1) {
                    spaceIndex = paramDoc.length();
                }
                String param = paramDoc.substring(0, spaceIndex);
                String paramComment = "";
                if (spaceIndex + 1 < paramDoc.length()) {
                    paramComment = paramDoc.substring(spaceIndex + 1);
                }
                paramComments.put(param, paramComment);
            }
        }
        return paramComments;
    }

    public boolean isVarArgs() {
        return ((ExecutableDeclaration)this.delegate).isVarArgs();
    }

    @Override
    public void accept(DeclarationVisitor v) {
        v.visitExecutableDeclaration((ExecutableDeclaration)this);
    }

    public Collection<TypeParameterDeclaration> getFormalTypeParameters() {
        return DeclarationDecorator.decorate(((ExecutableDeclaration)this.delegate).getFormalTypeParameters());
    }

    public Collection<ParameterDeclaration> getParameters() {
        Collection<ParameterDeclaration> params = DeclarationDecorator.decorate(((ExecutableDeclaration)this.delegate).getParameters());
        for (ParameterDeclaration param : params) {
            if (this.paramsComments.get(param.getSimpleName()) == null) continue;
            ((DecoratedParameterDeclaration)param).setDocComment(this.paramsComments.get(param.getSimpleName()));
        }
        return params;
    }

    public Collection<ReferenceType> getThrownTypes() {
        Collection<ReferenceType> thrownTypes = TypeMirrorDecorator.decorate(((ExecutableDeclaration)this.delegate).getThrownTypes());
        for (ReferenceType thrownType : thrownTypes) {
            String fullyQualifiedThrownTypeName = String.valueOf(thrownType);
            String throwsComment = this.throwsComments.get(fullyQualifiedThrownTypeName);
            if (throwsComment == null) {
                throwsComment = this.throwsComments.get(fullyQualifiedThrownTypeName.substring(fullyQualifiedThrownTypeName.lastIndexOf(46) + 1));
            }
            ((DecoratedReferenceType)thrownType).setDocComment(throwsComment);
        }
        return thrownTypes;
    }
}

