/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations.declaration;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.Declarations;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedExecutableDeclaration;
import net.sf.jelly.apt.decorations.type.DecoratedTypeMirror;
import net.sf.jelly.apt.util.JavaDocTagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratedMethodDeclaration
extends DecoratedExecutableDeclaration
implements MethodDeclaration {
    public static final Pattern INHERITDOC_PATTERN = Pattern.compile("^[ \\t]*\\{@inheritDoc.*?\\}[ \\t]*");

    public DecoratedMethodDeclaration(MethodDeclaration delegate) {
        super((ExecutableDeclaration)delegate);
    }

    @Override
    protected JavaDoc constructJavaDoc(String docComment, JavaDocTagHandler handler) {
        if (docComment == null || "".equals(docComment.trim()) || INHERITDOC_PATTERN.matcher(docComment).find()) {
            if (docComment == null) {
                docComment = "";
            }
            docComment = this.replaceDocInheritance(docComment);
        }
        return super.constructJavaDoc(docComment, handler);
    }

    private String replaceDocInheritance(String currentComment) {
        return this.replaceDocInheritance(new TreeSet<String>(), currentComment, ((MethodDeclaration)this.getDelegate()).getDeclaringType());
    }

    private String replaceDocInheritance(Set<String> visitedDecls, String currentComment, TypeDeclaration declaringType) {
        if (declaringType != null && this.commentNeedsReplacement(currentComment)) {
            ClassDeclaration decl;
            ClassType superClass;
            Declarations declarations = Context.getCurrentEnvironment().getDeclarationUtils();
            Collection superIfaces = declaringType.getSuperinterfaces();
            if (superIfaces != null) {
                ArrayList<InterfaceDeclaration> decls = new ArrayList<InterfaceDeclaration>(superIfaces.size());
                for (InterfaceType interfaceType : superIfaces) {
                    InterfaceDeclaration decl2 = interfaceType.getDeclaration();
                    if (decl2 == null || visitedDecls.contains(decl2.getQualifiedName())) continue;
                    visitedDecls.add(decl2.getQualifiedName());
                    for (MethodDeclaration methodDeclaration : decl2.getMethods()) {
                        MethodDeclaration decl1 = (MethodDeclaration)this.getDelegate();
                        while (decl1 instanceof DecoratedMethodDeclaration) {
                            decl1 = (MethodDeclaration)((DecoratedMethodDeclaration)decl1).getDelegate();
                        }
                        MethodDeclaration decl22 = methodDeclaration;
                        while (decl22 instanceof DecoratedMethodDeclaration) {
                            decl22 = (MethodDeclaration)((DecoratedMethodDeclaration)decl22).getDelegate();
                        }
                        if (!declarations.overrides(decl1, decl22) || this.commentNeedsReplacement(currentComment = this.doReplace(currentComment, decl22.getDocComment()))) continue;
                        return currentComment;
                    }
                    decls.add(decl2);
                }
                for (TypeDeclaration typeDeclaration : decls) {
                    if (this.commentNeedsReplacement(currentComment = this.replaceDocInheritance(visitedDecls, currentComment, typeDeclaration))) continue;
                    return currentComment;
                }
            }
            if (declaringType instanceof ClassDeclaration && (superClass = ((ClassDeclaration)declaringType).getSuperclass()) != null && (decl = superClass.getDeclaration()) != null && !Object.class.getName().equals(decl.getQualifiedName()) && !visitedDecls.contains(decl.getQualifiedName())) {
                visitedDecls.add(decl.getQualifiedName());
                for (MethodDeclaration methodDeclaration : decl.getMethods()) {
                    MethodDeclaration decl1 = (MethodDeclaration)this.getDelegate();
                    while (decl1 instanceof DecoratedMethodDeclaration) {
                        decl1 = (MethodDeclaration)((DecoratedMethodDeclaration)decl1).getDelegate();
                    }
                    MethodDeclaration decl2 = methodDeclaration;
                    while (decl2 instanceof DecoratedMethodDeclaration) {
                        decl2 = (MethodDeclaration)((DecoratedMethodDeclaration)decl2).getDelegate();
                    }
                    if (!declarations.overrides(decl1, decl2) || this.commentNeedsReplacement(currentComment = this.doReplace(currentComment, decl2.getDocComment()))) continue;
                    return currentComment;
                }
                if (!this.commentNeedsReplacement(currentComment = this.replaceDocInheritance(visitedDecls, currentComment, (TypeDeclaration)decl))) {
                    return currentComment;
                }
            }
        }
        return currentComment;
    }

    private String doReplace(String currentComment, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        if ("".equals(currentComment)) {
            return replacement.trim();
        }
        return INHERITDOC_PATTERN.matcher(currentComment).replaceAll(replacement);
    }

    protected boolean commentNeedsReplacement(String currentComment) {
        return currentComment == null || "".equals(currentComment.trim()) || INHERITDOC_PATTERN.matcher(currentComment).find();
    }

    public TypeMirror getReturnType() {
        DecoratedTypeMirror typeMirror = (DecoratedTypeMirror)TypeMirrorDecorator.decorate(((MethodDeclaration)this.delegate).getReturnType());
        if (this.getJavaDoc().get("return") != null) {
            typeMirror.setDocComment(((JavaDoc.JavaDocTagList)this.getJavaDoc().get("return")).toString());
        }
        return typeMirror;
    }

    public boolean isGetter() {
        return this.getSimpleName().startsWith("get") || this.isIs();
    }

    private boolean isIs() {
        return this.getSimpleName().startsWith("is") && this.getReturnType() instanceof PrimitiveType && ((PrimitiveType)this.getReturnType()).getKind() == PrimitiveType.Kind.BOOLEAN;
    }

    public boolean isSetter() {
        return this.getSimpleName().startsWith("set");
    }

    public String getPropertyName() {
        String propertyName = null;
        if (this.isIs()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().substring(2));
        } else if (this.isGetter() || this.isSetter()) {
            propertyName = Introspector.decapitalize(this.getSimpleName().substring(3));
        }
        return propertyName;
    }

    @Override
    public void accept(DeclarationVisitor v) {
        v.visitMethodDeclaration((MethodDeclaration)this);
    }
}

