/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.Declaration;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.TemplateLoopStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeclarationLoopStrategy<D extends Declaration, B extends TemplateBlock>
extends TemplateLoopStrategy<D, B> {
    private String var;
    private String indexVar;
    private D currentDeclaration;

    @Override
    protected Iterator<D> getLoop(TemplateModel model) throws TemplateException {
        return this.getDeclarations().iterator();
    }

    @Override
    protected void setupModelForLoop(TemplateModel model, D declaration, int index) throws TemplateException {
        super.setupModelForLoop(model, declaration, index);
        this.currentDeclaration = DeclarationDecorator.decorate(declaration);
        if (this.var != null) {
            model.setVariable(this.var, this.currentDeclaration);
        }
        if (this.indexVar != null) {
            model.setVariable(this.indexVar, index);
        }
    }

    public D getCurrentDeclaration() {
        return this.currentDeclaration;
    }

    public abstract Collection<D> getDeclarations() throws MissingParameterException;

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getIndexVar() {
        return this.indexVar;
    }

    public void setIndexVar(String indexVar) {
        this.indexVar = indexVar;
    }
}

