/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import java.io.IOException;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.TemplateOutput;
import net.sf.jelly.apt.strategies.TemplateBlockStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnwrapIfPrimitiveStrategy<B extends TemplateBlock>
extends TemplateBlockStrategy<B> {
    private TypeMirror type;

    @Override
    public void postProcess(B block, TemplateOutput<B> output, TemplateModel model) throws IOException, TemplateException {
        super.postProcess(block, output, model);
        if (this.type instanceof PrimitiveType) {
            String post;
            switch (((PrimitiveType)this.type).getKind()) {
                case BOOLEAN: {
                    post = ".booleanValue()";
                    break;
                }
                case BYTE: {
                    post = ".byteValue()";
                    break;
                }
                case CHAR: {
                    post = ".charValue()";
                    break;
                }
                case DOUBLE: {
                    post = ".doubleValue()";
                    break;
                }
                case FLOAT: {
                    post = ".floatValue()";
                    break;
                }
                case INT: {
                    post = ".intValue()";
                    break;
                }
                case LONG: {
                    post = ".longValue()";
                    break;
                }
                case SHORT: {
                    post = ".shortValue()";
                    break;
                }
                default: {
                    post = "";
                }
            }
            output.write(post);
        }
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }
}

