/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.decorations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jelly.apt.util.JavaDocTagHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDoc
extends HashMap<String, JavaDocTagList> {
    protected static final Pattern MARKUP_TAG_PATTERN = Pattern.compile("<([^ ]+)[^>]*>(.*?)</\\1>");
    protected static final Pattern INLINE_TAG_PATTERN = Pattern.compile("\\{@([^\\} ]+) ?(.*?)\\}");
    private String value;

    public JavaDoc() {
        this((String)null);
    }

    public JavaDoc(String docComment) {
        this(docComment, null);
    }

    public JavaDoc(String docComment, JavaDocTagHandler tagHandler) {
        if (docComment == null) {
            this.value = "";
        } else {
            BufferedReader reader = new BufferedReader(new StringReader(docComment));
            StringWriter currentValue = new StringWriter();
            PrintWriter out = new PrintWriter(currentValue);
            String currentTag = null;
            try {
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("@")) {
                        this.pushValue(currentTag, currentValue.toString());
                        int spaceIndex = line.indexOf(32);
                        if (spaceIndex == -1) {
                            spaceIndex = line.length();
                        }
                        currentTag = line.substring(1, spaceIndex);
                        String value = "";
                        if (spaceIndex + 1 < line.length()) {
                            value = line.substring(spaceIndex + 1);
                        }
                        currentValue = new StringWriter();
                        out = new PrintWriter(currentValue);
                        out.println(value);
                    } else {
                        out.println(line);
                    }
                    line = reader.readLine();
                }
                this.pushValue(currentTag, currentValue.toString());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (tagHandler != null) {
            this.value = this.handleAllTags(this.value, tagHandler);
            for (Map.Entry entry : this.entrySet()) {
                JavaDocTagList tagValues = (JavaDocTagList)entry.getValue();
                for (int i = 0; i < tagValues.size(); ++i) {
                    String value = (String)tagValues.get(i);
                    tagValues.set(i, this.handleAllTags(value, tagHandler));
                }
            }
        }
    }

    protected String handleAllTags(String value, JavaDocTagHandler handler) {
        Object replacement;
        StringBuilder builder = new StringBuilder();
        Matcher matcher = INLINE_TAG_PATTERN.matcher(value);
        int lastStart = 0;
        while (matcher.find()) {
            builder.append(value.substring(lastStart, matcher.start()));
            replacement = handler.onInlineTag(matcher.group(1), matcher.group(2));
            if (replacement != null) {
                if (replacement instanceof JavaDocTagHandler.TextToBeHandled) {
                    replacement = this.handleAllTags(String.valueOf(replacement), handler);
                }
                builder.append(replacement);
            } else {
                builder.append(value.substring(matcher.start(), matcher.end()));
            }
            lastStart = matcher.end();
        }
        builder.append(value.substring(lastStart, value.length()));
        value = builder.toString();
        builder = new StringBuilder();
        matcher = MARKUP_TAG_PATTERN.matcher(value);
        lastStart = 0;
        while (matcher.find()) {
            builder.append(value.substring(lastStart, matcher.start()));
            replacement = handler.onMarkupTag(matcher.group(1), matcher.group(2));
            if (replacement != null) {
                if (replacement instanceof JavaDocTagHandler.TextToBeHandled) {
                    replacement = this.handleAllTags(String.valueOf(replacement), handler);
                }
                builder.append(replacement);
            } else {
                builder.append(value.substring(matcher.start(), matcher.end()));
            }
            lastStart = matcher.end();
        }
        builder.append(value.substring(lastStart, value.length()));
        return builder.toString();
    }

    private void pushValue(String tag, String value) {
        value = value.trim();
        if (tag == null) {
            this.value = value;
        } else {
            JavaDocTagList tagList = (JavaDocTagList)this.get(tag);
            if (tagList == null) {
                tagList = new JavaDocTagList(value);
                this.put(tag, tagList);
            } else {
                tagList.add(value);
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaDocTagList
    extends ArrayList<String> {
        public JavaDocTagList(String firstValue) {
            this.add(firstValue);
        }

        @Override
        public String toString() {
            return (String)this.get(0);
        }
    }
}

