/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.TemplateModel;
import net.sf.jelly.apt.strategies.DeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationFilterableDeclarationLoopStrategy<D extends Declaration, B extends TemplateBlock>
extends DeclarationLoopStrategy<D, B> {
    private String annotation;
    private String annotationVar;
    private String excludes;

    @Override
    protected void setupModelForLoop(TemplateModel model, D declaration, int index) throws TemplateException {
        super.setupModelForLoop(model, declaration, index);
        if (this.annotationVar != null) {
            Collection annotations = this.getCurrentDeclaration().getAnnotationMirrors();
            for (AnnotationMirror mirror : annotations) {
                AnnotationTypeDeclaration annotation = mirror.getAnnotationType().getDeclaration();
                if (annotation == null || !annotation.getQualifiedName().equals(this.annotation)) continue;
                model.setVariable(this.annotationVar, mirror);
            }
        }
    }

    public abstract Collection<D> getAllDeclarationsToConsiderForAnnotationFiltering() throws MissingParameterException;

    @Override
    public Collection<D> getDeclarations() throws MissingParameterException {
        if (this.annotation == null && this.excludes == null) {
            return this.getAllDeclarationsToConsiderForAnnotationFiltering();
        }
        ArrayList<D> declarations = new ArrayList<D>(this.getAllDeclarationsToConsiderForAnnotationFiltering());
        if (this.annotation != null) {
            Iterator<D> it = declarations.iterator();
            while (it.hasNext()) {
                Declaration declaration = (Declaration)it.next();
                if (this.hasAnnotation(declaration, this.annotation)) continue;
                it.remove();
            }
        }
        if (this.excludes != null) {
            HashSet<String> excludesSet = new HashSet<String>();
            for (String excludeAnnotation : this.excludes.split(",")) {
                if ((excludeAnnotation = excludeAnnotation.trim()).length() <= 0) continue;
                excludesSet.add(excludeAnnotation);
            }
            Iterator<D> it = declarations.iterator();
            block2: while (it.hasNext()) {
                Declaration declaration = (Declaration)it.next();
                for (String exclude : excludesSet) {
                    if (!this.hasAnnotation(declaration, exclude)) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        return declarations;
    }

    protected boolean hasAnnotation(D declaration, String annotationName) {
        for (AnnotationMirror mirror : declaration.getAnnotationMirrors()) {
            AnnotationTypeDeclaration annotation = mirror.getAnnotationType().getDeclaration();
            if (annotation == null || !annotation.getQualifiedName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getAnnotationVar() {
        return this.annotationVar;
    }

    public void setAnnotationVar(String annotationVar) {
        this.annotationVar = annotationVar;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }
}

