/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.AnnotationType;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.strategies.DeclarationLoopStrategy;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.StrategyStack;
import net.sf.jelly.apt.strategies.TemplateValueStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValueStrategy<B extends TemplateBlock>
extends TemplateValueStrategy<B> {
    private Declaration declaration;
    private String defaultValue;
    private String annotation;
    private String element;

    @Override
    protected String getValue() throws TemplateException {
        Declaration declaration = this.getDeclaration();
        if (declaration == null && (declaration = this.getCurrentDeclaration()) == null) {
            throw new MissingParameterException("declaration");
        }
        if (this.annotation == null) {
            throw new MissingParameterException("annotation");
        }
        String element = this.element;
        if (element == null) {
            element = "value";
        }
        Object output = this.defaultValue;
        block0: for (AnnotationMirror annotationMirror : declaration.getAnnotationMirrors()) {
            AnnotationTypeDeclaration annotationTypeDeclaration;
            AnnotationType annotationType = annotationMirror.getAnnotationType();
            if (annotationType == null || (annotationTypeDeclaration = annotationType.getDeclaration()) == null || !this.annotation.equals(annotationTypeDeclaration.getQualifiedName())) continue;
            for (AnnotationTypeElementDeclaration elementDeclaration : annotationTypeDeclaration.getMethods()) {
                if (!element.equals(elementDeclaration.getSimpleName())) continue;
                AnnotationValue annotationValue = (AnnotationValue)annotationMirror.getElementValues().get(elementDeclaration);
                AnnotationValue defaultValue = elementDeclaration.getDefaultValue();
                if (annotationValue != null) {
                    output = annotationValue.getValue();
                    break block0;
                }
                if (this.defaultValue != null) break block0;
                output = defaultValue.getValue();
                break block0;
            }
        }
        if (output != null) {
            return output.toString();
        }
        return null;
    }

    protected Declaration getCurrentDeclaration() {
        DeclarationLoopStrategy loop = StrategyStack.get().findFirst(DeclarationLoopStrategy.class);
        if (loop != null) {
            return loop.getCurrentDeclaration();
        }
        return null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(Declaration declaration) {
        this.declaration = declaration;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String element) {
        this.element = element;
    }
}

