/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.strategies;

import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import net.sf.jelly.apt.TemplateBlock;
import net.sf.jelly.apt.TemplateException;
import net.sf.jelly.apt.strategies.MissingParameterException;
import net.sf.jelly.apt.strategies.TemplateValueStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveWrapperStrategy<B extends TemplateBlock>
extends TemplateValueStrategy<B> {
    private TypeMirror type;

    @Override
    protected String getValue() throws TemplateException {
        if (this.type == null) {
            throw new MissingParameterException("type");
        }
        if (!(this.type instanceof PrimitiveType)) {
            throw new TemplateException("'type' must be a primitive type.");
        }
        switch (((PrimitiveType)this.type).getKind()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTE: {
                return "Byte";
            }
            case CHAR: {
                return "Character";
            }
            case DOUBLE: {
                return "Double";
            }
            case FLOAT: {
                return "Float";
            }
            case INT: {
                return "Integer";
            }
            case LONG: {
                return "Long";
            }
            case SHORT: {
                return "Short";
            }
        }
        throw new TemplateException("No wrapper for primitive type " + this.type);
    }

    public TypeMirror getType() {
        return this.type;
    }

    public void setType(TypeMirror type) {
        this.type = type;
    }
}

