/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.freemarker;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.type.TypeMirror;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import net.sf.jelly.apt.decorations.DeclarationDecorator;
import net.sf.jelly.apt.decorations.JavaDoc;
import net.sf.jelly.apt.decorations.TypeMirrorDecorator;
import net.sf.jelly.apt.decorations.declaration.DecoratedAnnotationMirror;
import net.sf.jelly.apt.freemarker.FreemarkerJavaDoc;

public class APTJellyObjectWrapper
extends DefaultObjectWrapper {
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj instanceof Declaration) {
            obj = DeclarationDecorator.decorate((Declaration)((Declaration)obj));
        } else if (obj instanceof TypeMirror) {
            obj = TypeMirrorDecorator.decorate((TypeMirror)((TypeMirror)obj));
        } else if (obj instanceof AnnotationMirror && !(obj instanceof DecoratedAnnotationMirror)) {
            obj = new DecoratedAnnotationMirror((AnnotationMirror)obj);
        } else {
            if (obj instanceof JavaDoc) {
                return new FreemarkerJavaDoc((JavaDoc)obj);
            }
            if (obj instanceof Boolean) {
                return new ScalarBooleanModel((Boolean)obj);
            }
        }
        return super.wrap(obj);
    }

    private static class ScalarBooleanModel
    implements TemplateBooleanModel,
    TemplateScalarModel {
        private final boolean value;

        public ScalarBooleanModel(boolean value) {
            this.value = value;
        }

        public boolean getAsBoolean() throws TemplateModelException {
            return this.value;
        }

        public String getAsString() throws TemplateModelException {
            return String.valueOf(this.value);
        }
    }
}

