/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.freemarker;

import com.sun.mirror.apt.AnnotationProcessor;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jelly.apt.Context;
import net.sf.jelly.apt.freemarker.APTJellyObjectWrapper;
import net.sf.jelly.apt.freemarker.FreemarkerModel;
import net.sf.jelly.apt.freemarker.FreemarkerTransform;
import net.sf.jelly.apt.freemarker.FreemarkerVariable;
import net.sf.jelly.apt.freemarker.transforms.AnnotationValueTransform;
import net.sf.jelly.apt.freemarker.transforms.FileTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllConstructorsTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllFieldsTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllImportedTypesTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllMethodsTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllNestedTypesTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllPackagesTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllParametersTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllPropertiesTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllThrownTypesTransform;
import net.sf.jelly.apt.freemarker.transforms.ForAllTypesTransform;
import net.sf.jelly.apt.freemarker.transforms.IfHasAnnotationTransform;
import net.sf.jelly.apt.freemarker.transforms.IfHasDeclarationTransform;
import net.sf.jelly.apt.freemarker.transforms.JavaSourceTransform;
import net.sf.jelly.apt.freemarker.transforms.PrimitiveWrapperTransform;
import net.sf.jelly.apt.freemarker.transforms.UnwrapIfPrimitiveTransform;
import net.sf.jelly.apt.freemarker.transforms.WrapIfPrimitiveTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerProcessor
implements AnnotationProcessor {
    private final URL templateURL;

    public FreemarkerProcessor(URL templateURL) {
        this.templateURL = templateURL;
    }

    public void process() {
        Configuration configuration = this.getConfiguration();
        try {
            Template template = configuration.getTemplate(this.getTemplateURL().toString());
            template.process((Object)this.getRootModel(), (Writer)new OutputStreamWriter(System.out));
        }
        catch (IOException e) {
            this.process(e);
        }
        catch (TemplateException e) {
            this.process(e);
        }
    }

    public URL getTemplateURL() {
        return this.templateURL;
    }

    protected void process(TemplateException e) {
        throw new RuntimeException(e);
    }

    protected void process(IOException e) {
        throw new RuntimeException(e);
    }

    protected APTJellyObjectWrapper getObjectWrapper() {
        return new APTJellyObjectWrapper();
    }

    protected FreemarkerModel getRootModel() throws TemplateModelException {
        String namespace;
        HashMap sourceMap = new HashMap();
        for (FreemarkerVariable var : this.getVariables()) {
            namespace = var.getNamespace();
            if (!sourceMap.containsKey(namespace)) {
                sourceMap.put(namespace, new HashMap());
            }
            ((Map)sourceMap.get(namespace)).put(var.getName(), var.getValue());
        }
        for (FreemarkerTransform transform : this.getTransforms()) {
            namespace = transform.getTransformNamespace();
            if (!sourceMap.containsKey(namespace)) {
                sourceMap.put(namespace, new HashMap());
            }
            ((Map)sourceMap.get(namespace)).put(transform.getTransformName(), transform);
        }
        FreemarkerModel model = this.newRootModel();
        FreemarkerModel.set(model);
        model.setObjectWrapper((ObjectWrapper)this.getObjectWrapper());
        if (sourceMap.containsKey(null)) {
            model.putAll((Map)sourceMap.remove(null));
        }
        model.putAll(sourceMap);
        return model;
    }

    protected FreemarkerModel newRootModel() {
        return new FreemarkerModel();
    }

    protected Configuration getConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader((TemplateLoader)this.getTemplateLoader());
        configuration.setLocalizedLookup(false);
        return configuration;
    }

    protected Collection<FreemarkerTransform> getTransforms() {
        String namespace = (String)Context.getCurrentEnvironment().getOptions().get("-AAPTJellyFreemarkerLibraryNS");
        ArrayList<FreemarkerTransform> transforms = new ArrayList<FreemarkerTransform>();
        transforms.add(new AnnotationValueTransform(namespace));
        transforms.add(new FileTransform(namespace));
        transforms.add(new ForAllConstructorsTransform(namespace));
        transforms.add(new ForAllFieldsTransform(namespace));
        transforms.add(new ForAllImportedTypesTransform(namespace));
        transforms.add(new ForAllMethodsTransform(namespace));
        transforms.add(new ForAllNestedTypesTransform(namespace));
        transforms.add(new ForAllPackagesTransform(namespace));
        transforms.add(new ForAllParametersTransform(namespace));
        transforms.add(new ForAllPropertiesTransform(namespace));
        transforms.add(new ForAllThrownTypesTransform(namespace));
        transforms.add(new ForAllTypesTransform(namespace));
        transforms.add(new IfHasAnnotationTransform(namespace));
        transforms.add(new IfHasDeclarationTransform(namespace));
        transforms.add(new JavaSourceTransform(namespace));
        transforms.add(new PrimitiveWrapperTransform(namespace));
        transforms.add(new WrapIfPrimitiveTransform(namespace));
        transforms.add(new UnwrapIfPrimitiveTransform(namespace));
        return transforms;
    }

    protected Collection<FreemarkerVariable> getVariables() {
        ArrayList<FreemarkerVariable> variables = new ArrayList<FreemarkerVariable>();
        Map options = Context.getCurrentEnvironment().getOptions();
        String namespace = (String)options.get("-AAPTJellyFreemarkerLibraryNS");
        variables.add(new FreemarkerVariable(namespace, "aptOptions", options));
        return variables;
    }

    protected URLTemplateLoader getTemplateLoader() {
        return new URLTemplateLoader(){

            protected URL getURL(String name) {
                try {
                    return new URL(name);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        };
    }
}

