/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.beanlib.CollectionPropertyName;
import net.sf.beanlib.hibernate.HibernatePropertyFilter;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.hibernate3.Hibernate3BeanReplicator;
import net.sf.beanlib.provider.collector.ProtectedSetterMethodCollector;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.spi.DetailedPropertyFilter;
import net.sf.beanlib.utils.ClassUtils;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate3DtoCopier {
    private final String applicationPackagePrefix;

    public Hibernate3DtoCopier() {
        this.applicationPackagePrefix = "#";
    }

    public Hibernate3DtoCopier(String applicationPackagePrefix) {
        this.applicationPackagePrefix = applicationPackagePrefix;
    }

    public Hibernate3DtoCopier(String applicationPackagePrefix, Class<?> applicationSampleClass) {
        this.applicationPackagePrefix = applicationPackagePrefix;
        if (applicationSampleClass != null && !ClassUtils.fqcn(applicationSampleClass).startsWith(applicationPackagePrefix)) {
            throw new IllegalArgumentException("The specified application package prefix " + applicationPackagePrefix + " is not consistent with the given sample application class " + applicationSampleClass);
        }
    }

    protected Hibernate3BeanReplicator createHibernateBeanReplicator() {
        return new Hibernate3BeanReplicator();
    }

    public <T> T hibernate2dtoFully(Object from) {
        return (T)(from == null ? null : this.createHibernateBeanReplicator().deepCopy(from));
    }

    public List<?> hibernate2dtoFully(Collection<?> hibernateBeans) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList list = new ArrayList(hibernateBeans.size());
        Hibernate3BeanReplicator replicator = this.createHibernateBeanReplicator();
        for (Object obj : hibernateBeans) {
            list.add(replicator.deepCopy(obj));
        }
        return list;
    }

    public <T> T hibernate2dto(Object entityBean) {
        return this.hibernate2dto(UnEnhancer.getActualClass(entityBean), entityBean);
    }

    public <E, T> E hibernate2dto(Class<E> targetEntityType, T entityBean) {
        if (entityBean == null) {
            return null;
        }
        return this.copy(targetEntityType, entityBean, ArrayUtils.EMPTY_CLASS_ARRAY);
    }

    public <T> T hibernate2dto(T from, Class<?>[] interestedEntityTypes, CollectionPropertyName[] collectionPropertyNames) {
        return this.hibernate2dto(UnEnhancer.getActualClass(from), from, interestedEntityTypes, collectionPropertyNames);
    }

    public <E, T> E hibernate2dto(Class<E> targetEntityType, T from, Class<?>[] interestedEntityTypes, CollectionPropertyName<?>[] collectionPropertyNames) {
        if (from == null) {
            return null;
        }
        return this.copy(targetEntityType, from, interestedEntityTypes, collectionPropertyNames);
    }

    public List<?> hibernate2dto(Collection<?> hibernateBeans) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(hibernateBeans.size());
        for (Object entityBean : hibernateBeans) {
            Object to = this.copy(entityBean, ArrayUtils.EMPTY_CLASS_ARRAY);
            list.add(to);
        }
        return list;
    }

    public <E> List<E> hibernate2dto(Class<E> targetEntityType, Collection<?> hibernateBeans, Class<?>[] interestedEntityTypes, CollectionPropertyName<?>[] collectionPropertyNames) {
        if (hibernateBeans == null) {
            return null;
        }
        ArrayList<E> list = new ArrayList<E>(hibernateBeans.size());
        for (Object entityBean : hibernateBeans) {
            E to = this.copy(targetEntityType, entityBean, interestedEntityTypes, collectionPropertyNames);
            list.add(to);
        }
        return list;
    }

    private Object copy(Object from, Class<?>[] interestedEntityTypes) {
        if (from == null) {
            return null;
        }
        return this.copy(UnEnhancer.getActualClass(from), from, interestedEntityTypes, CollectionPropertyName.EMPTY_ARRAY);
    }

    private <E> E copy(Class<E> targetEntityType, Object from, Class<?>[] interestedEntityTypes) {
        if (from == null) {
            return null;
        }
        return this.copy(targetEntityType, from, interestedEntityTypes, CollectionPropertyName.EMPTY_ARRAY);
    }

    private <E> E copy(Class<E> targetEntityType, Object from, Class<?>[] interestedEntityTypes, CollectionPropertyName<?>[] collectionPropertyNames) {
        if (from == null) {
            return null;
        }
        Hibernate3BeanReplicator replicator = this.createHibernateBeanReplicator();
        Set<Class<?>> entityBeanClassSet = null;
        if (interestedEntityTypes != null) {
            entityBeanClassSet = interestedEntityTypes.length == 0 ? Collections.emptySet() : new HashSet(Arrays.asList(interestedEntityTypes));
        }
        Set<Object> collectionPropertyNameSet = null;
        if (collectionPropertyNames != null) {
            collectionPropertyNameSet = collectionPropertyNames.length == 0 ? Collections.emptySet() : new HashSet(Arrays.asList(collectionPropertyNames));
        }
        HibernatePropertyFilter propertyFilter = new HibernatePropertyFilter(this.applicationPackagePrefix, entityBeanClassSet, collectionPropertyNameSet, null);
        replicator.initPropertyFilter(propertyFilter).initDetailedPropertyFilter(DetailedPropertyFilter.ALWAYS_PROPAGATE).initSetterMethodCollector((BeanMethodCollector)new ProtectedSetterMethodCollector());
        Object ret = replicator.copy(from, UnEnhancer.unenhanceClass(targetEntityType));
        return (E)ret;
    }
}

