/*
 * Decompiled with CFR 0.152.
 */
package del.icio.us;

import del.icio.us.DeliciousException;
import del.icio.us.DeliciousNotAuthorizedException;
import del.icio.us.DeliciousUtils;
import del.icio.us.beans.Bundle;
import del.icio.us.beans.DeliciousDate;
import del.icio.us.beans.Post;
import del.icio.us.beans.Subscription;
import del.icio.us.beans.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Delicious {
    private Log logger = LogFactory.getLog((Class)(class$del$icio$us$Delicious == null ? (class$del$icio$us$Delicious = Delicious.class$("del.icio.us.Delicious")) : class$del$icio$us$Delicious));
    private HttpClient httpClient;
    private DocumentBuilder documentBuilder;
    private String apiEndpoint;
    private int httpResult;
    private Object resultMetaInformation;
    static /* synthetic */ Class class$del$icio$us$Delicious;

    public Delicious(String username, String password) {
        this(username, password, "https://api.del.icio.us/v1/");
    }

    public Delicious(String username, String password, String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        this.httpClient = new HttpClient();
        HttpClientParams httpClientParams = new HttpClientParams();
        DefaultHttpMethodRetryHandler defaultHttpMethodRetryHandler = new DefaultHttpMethodRetryHandler(0, false);
        httpClientParams.setParameter("User-Agent", (Object)"del.icio.us Java/1.14");
        httpClientParams.setParameter("http.method.retry-handler", (Object)defaultHttpMethodRetryHandler);
        this.httpClient.setParams(httpClientParams);
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setNamespaceAware(false);
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)e);
        }
    }

    public Delicious(String username, String password, String apiEndpoint, String proxyHost, int proxyPort) {
        this(username, password, apiEndpoint);
        this.setProxyConfiguration(proxyHost, proxyPort);
    }

    public void setProxyConfiguration(String proxyHost, int proxyPort) {
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setProxy(proxyHost, proxyPort);
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    public void setProxyAuthenticationConfiguration(String proxyUsername, String proxyPassword) {
        this.httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    public int getHttpResult() {
        return this.httpResult;
    }

    public List getDatesWithPost(String tag) {
        this.clearResultMetaInformation();
        ArrayList<DeliciousDate> dates = new ArrayList<DeliciousDate>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/dates?");
        get.setDoAuthentication(true);
        if (!DeliciousUtils.checkNullOrBlank(tag)) {
            NameValuePair tagParam = new NameValuePair("tag", tag);
            get.setQueryString(new NameValuePair[]{tagParam});
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList dateItems = document.getElementsByTagName("date");
                if (dateItems != null && dateItems.getLength() > 0) {
                    for (int i = 0; i < dateItems.getLength(); ++i) {
                        Node dateItem = dateItems.item(i);
                        String count = dateItem.getAttributes().getNamedItem("count").getNodeValue();
                        String dateAttribute = dateItem.getAttributes().getNamedItem("date").getNodeValue();
                        DeliciousDate date = new DeliciousDate(Integer.parseInt(count), dateAttribute);
                        dates.add(date);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parsing error", e);
        }
        return dates;
    }

    public List getDatesWithPost() {
        return this.getDatesWithPost(null);
    }

    public List getTags() {
        this.clearResultMetaInformation();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "tags/get?");
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList tagItems = document.getElementsByTagName("tag");
                if (tagItems != null && tagItems.getLength() > 0) {
                    for (int i = 0; i < tagItems.getLength(); ++i) {
                        Node tagItem = tagItems.item(i);
                        String count = tagItem.getAttributes().getNamedItem("count").getNodeValue();
                        String tagAttribute = tagItem.getAttributes().getNamedItem("tag").getNodeValue();
                        Tag tag = new Tag(Integer.parseInt(count), tagAttribute);
                        tags.add(tag);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parsing error", e);
        }
        return tags;
    }

    public List getPosts(String filterTag, Date date, String url) {
        this.clearResultMetaInformation();
        ArrayList<Post> posts = new ArrayList<Post>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/get?");
        get.setDoAuthentication(true);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (!DeliciousUtils.checkNullOrBlank(filterTag)) {
            NameValuePair tag = new NameValuePair("tag", filterTag);
            params.add(tag);
        }
        if (date != null) {
            NameValuePair dt = new NameValuePair("dt", DeliciousUtils.getDeliciousDate(date));
            params.add(dt);
        }
        if (!DeliciousUtils.checkNullOrBlank(url)) {
            NameValuePair urlParam = new NameValuePair("url", url);
            params.add(urlParam);
        }
        if (params.size() > 0) {
            get.setQueryString(params.toArray(new NameValuePair[params.size()]));
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList postItems = document.getElementsByTagName("post");
                if (postItems != null && postItems.getLength() > 0) {
                    for (int i = 0; i < postItems.getLength(); ++i) {
                        Node postItem = postItems.item(i);
                        String href = postItem.getAttributes().getNamedItem("href").getNodeValue();
                        String description = postItem.getAttributes().getNamedItem("description").getNodeValue();
                        String hash = postItem.getAttributes().getNamedItem("hash").getNodeValue();
                        String tag = postItem.getAttributes().getNamedItem("tag").getNodeValue();
                        String time = postItem.getAttributes().getNamedItem("time").getNodeValue();
                        String extended = null;
                        if (postItem.getAttributes().getNamedItem("extended") != null) {
                            extended = postItem.getAttributes().getNamedItem("extended").getNodeValue();
                        }
                        boolean shared = true;
                        if (postItem.getAttributes().getNamedItem("shared") != null) {
                            shared = Boolean.valueOf(postItem.getAttributes().getNamedItem("shared").getNodeValue());
                        }
                        Post post = new Post(href, description, extended, hash, tag, time, shared);
                        posts.add(post);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parsing error", e);
        }
        return posts;
    }

    public List getPostsForDate(String filterTag, Date date) {
        return this.getPosts(filterTag, date, null);
    }

    public List getPosts() {
        return this.getPosts(null, null, null);
    }

    public List getPostForURL(String url) {
        return this.getPosts(null, null, url);
    }

    public List getPostsForTag(String tag) {
        return this.getPosts(tag, null, null);
    }

    public List getPostsForTags(String[] tags) {
        if (tags == null) {
            return new ArrayList();
        }
        ArrayList<Post> postsForTags = new ArrayList<Post>(tags.length);
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            List posts = this.getPostsForTag(tag);
            for (int j = 0; j < posts.size(); ++j) {
                Post post = (Post)posts.get(j);
                postsForTags.add(post);
            }
        }
        return postsForTags;
    }

    public List getRecentPosts(String filterTag, int count) {
        this.clearResultMetaInformation();
        ArrayList<Post> posts = new ArrayList<Post>();
        StringBuffer result = new StringBuffer();
        if (count <= 0) {
            count = 15;
        }
        if (count > 100) {
            count = 100;
        }
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/recent?");
        get.setDoAuthentication(true);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        NameValuePair countParam = new NameValuePair("count", Integer.toString(count));
        params.add(countParam);
        if (!DeliciousUtils.checkNullOrBlank(filterTag)) {
            NameValuePair tagParam = new NameValuePair("tag", filterTag);
            params.add(tagParam);
        }
        if (params.size() > 0) {
            get.setQueryString(params.toArray(new NameValuePair[params.size()]));
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList postItems = document.getElementsByTagName("post");
                if (postItems != null && postItems.getLength() > 0) {
                    for (int i = 0; i < postItems.getLength(); ++i) {
                        Node postItem = postItems.item(i);
                        String href = postItem.getAttributes().getNamedItem("href").getNodeValue();
                        String description = postItem.getAttributes().getNamedItem("description").getNodeValue();
                        String hash = postItem.getAttributes().getNamedItem("hash").getNodeValue();
                        String tag = postItem.getAttributes().getNamedItem("tag").getNodeValue();
                        String time = postItem.getAttributes().getNamedItem("time").getNodeValue();
                        String extended = null;
                        if (postItem.getAttributes().getNamedItem("extended") != null) {
                            extended = postItem.getAttributes().getNamedItem("extended").getNodeValue();
                        }
                        boolean shared = true;
                        if (postItem.getAttributes().getNamedItem("shared") != null) {
                            shared = Boolean.valueOf(postItem.getAttributes().getNamedItem("shared").getNodeValue());
                        }
                        Post post = new Post(href, description, extended, hash, tag, time, shared);
                        posts.add(post);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parsing error", e);
        }
        return posts;
    }

    public List getRecentPosts(String filterTag) {
        return this.getRecentPosts(filterTag, 15);
    }

    public List getRecentPosts() {
        return this.getRecentPosts(null, 15);
    }

    public List getAllPosts(String filterTag) {
        this.clearResultMetaInformation();
        ArrayList<Post> posts = new ArrayList<Post>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/all?");
        if (!DeliciousUtils.checkNullOrBlank(filterTag)) {
            get.setQueryString(new NameValuePair[]{new NameValuePair("tag", filterTag)});
        }
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                NodeList postItems;
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList postsTag = document.getElementsByTagName("posts");
                if (postsTag != null && postsTag.getLength() > 0) {
                    Node postsItem = postsTag.item(0);
                    String updateTime = postsItem.getAttributes().getNamedItem("update").getNodeValue();
                    this.resultMetaInformation = DeliciousUtils.getDateFromUTCString(updateTime);
                }
                if ((postItems = document.getElementsByTagName("post")) != null && postItems.getLength() > 0) {
                    for (int i = 0; i < postItems.getLength(); ++i) {
                        Node postItem = postItems.item(i);
                        String href = postItem.getAttributes().getNamedItem("href").getNodeValue();
                        String description = postItem.getAttributes().getNamedItem("description").getNodeValue();
                        String hash = postItem.getAttributes().getNamedItem("hash").getNodeValue();
                        String tag = postItem.getAttributes().getNamedItem("tag").getNodeValue();
                        String time = postItem.getAttributes().getNamedItem("time").getNodeValue();
                        String extended = null;
                        if (postItem.getAttributes().getNamedItem("extended") != null) {
                            extended = postItem.getAttributes().getNamedItem("extended").getNodeValue();
                        }
                        boolean shared = true;
                        if (postItem.getAttributes().getNamedItem("shared") != null) {
                            shared = Boolean.valueOf(postItem.getAttributes().getNamedItem("shared").getNodeValue());
                        }
                        Post post = new Post(href, description, extended, hash, tag, time, shared);
                        posts.add(post);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parsing error", e);
        }
        return posts;
    }

    public List getAllPosts() {
        return this.getAllPosts(null);
    }

    public boolean addPost(String url, String description, String extended, String tags, Date date, boolean replace, boolean shared) {
        this.clearResultMetaInformation();
        boolean addPostResult = false;
        StringBuffer result = new StringBuffer();
        PostMethod post = new PostMethod(this.apiEndpoint + "posts/add?");
        post.setDoAuthentication(true);
        if (DeliciousUtils.checkNullOrBlank(url)) {
            return false;
        }
        if (DeliciousUtils.checkNullOrBlank(description)) {
            return false;
        }
        NameValuePair urlParam = new NameValuePair("url", url);
        post.addParameter(urlParam);
        NameValuePair descriptionParam = new NameValuePair("description", description);
        post.addParameter(descriptionParam);
        if (!DeliciousUtils.checkNullOrBlank(extended)) {
            NameValuePair extendedParam = new NameValuePair("extended", extended);
            post.addParameter(extendedParam);
        }
        if (!DeliciousUtils.checkNullOrBlank(tags)) {
            NameValuePair tagsParam = new NameValuePair("tags", tags);
            post.addParameter(tagsParam);
        }
        if (date != null) {
            NameValuePair dtParam = new NameValuePair("dt", DeliciousUtils.getUTCDate(date));
            post.addParameter(dtParam);
        }
        NameValuePair replaceParam = new NameValuePair();
        replaceParam.setName("replace");
        replaceParam.setValue("no");
        if (replace) {
            replaceParam.setValue("yes");
            post.addParameter(replaceParam);
        }
        if (!shared) {
            NameValuePair sharedParam = new NameValuePair();
            sharedParam.setName("shared");
            sharedParam.setValue("no");
            post.addParameter(sharedParam);
        }
        try {
            post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            this.httpResult = this.httpClient.executeMethod((HttpMethod)post);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (post.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                post.releaseConnection();
                if (result.indexOf("done") != -1) {
                    addPostResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return addPostResult;
    }

    public boolean addPost(String url, String description, String extended, String tags, Date date) {
        return this.addPost(url, description, extended, tags, date, false, true);
    }

    public boolean addPost(String url, String description) {
        return this.addPost(url, description, null, null, null, false, true);
    }

    public boolean deletePost(String url) {
        this.clearResultMetaInformation();
        boolean deletePostResult = false;
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/delete?");
        get.setDoAuthentication(true);
        NameValuePair urlParam = new NameValuePair("url", url);
        get.setQueryString(new NameValuePair[]{urlParam});
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                if (result.indexOf("done") != -1) {
                    deletePostResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return deletePostResult;
    }

    public boolean renameTag(String oldTag, String newTag) {
        this.clearResultMetaInformation();
        boolean renameTagResult = false;
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "tags/rename?");
        get.setDoAuthentication(true);
        NameValuePair oldParam = new NameValuePair("old", oldTag);
        NameValuePair newParam = new NameValuePair("new", newTag);
        get.setQueryString(new NameValuePair[]{oldParam, newParam});
        try {
            get.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                if (result.indexOf("done") != -1) {
                    renameTagResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return renameTagResult;
    }

    public List getInboxEntries(Date date) {
        this.clearResultMetaInformation();
        ArrayList<Post> posts = new ArrayList<Post>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "inbox/get?");
        get.setDoAuthentication(true);
        if (date != null) {
            NameValuePair dateParam = new NameValuePair("dt", DeliciousUtils.getDeliciousDate(date));
            get.setQueryString(new NameValuePair[]{dateParam});
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList postItems = document.getElementsByTagName("post");
                if (postItems != null && postItems.getLength() > 0) {
                    for (int i = 0; i < postItems.getLength(); ++i) {
                        Node postItem = postItems.item(i);
                        String href = postItem.getAttributes().getNamedItem("href").getNodeValue();
                        String description = postItem.getAttributes().getNamedItem("description").getNodeValue();
                        String hash = postItem.getAttributes().getNamedItem("hash").getNodeValue();
                        String tag = postItem.getAttributes().getNamedItem("tag").getNodeValue();
                        String time = postItem.getAttributes().getNamedItem("time").getNodeValue();
                        String extended = null;
                        if (postItem.getAttributes().getNamedItem("extended") != null) {
                            extended = postItem.getAttributes().getNamedItem("extended").getNodeValue();
                        }
                        boolean shared = true;
                        if (postItem.getAttributes().getNamedItem("shared") != null) {
                            shared = Boolean.valueOf(postItem.getAttributes().getNamedItem("shared").getNodeValue());
                        }
                        Post post = new Post(href, description, extended, hash, tag, time, shared);
                        posts.add(post);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parse error", e);
        }
        return posts;
    }

    public List getDatesWithInboxEntries() {
        this.clearResultMetaInformation();
        ArrayList<DeliciousDate> dates = new ArrayList<DeliciousDate>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "inbox/dates?");
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList dateItems = document.getElementsByTagName("date");
                if (dateItems != null && dateItems.getLength() > 0) {
                    for (int i = 0; i < dateItems.getLength(); ++i) {
                        Node dateItem = dateItems.item(i);
                        String count = dateItem.getAttributes().getNamedItem("count").getNodeValue();
                        String dateAttribute = dateItem.getAttributes().getNamedItem("date").getNodeValue();
                        DeliciousDate date = new DeliciousDate(Integer.parseInt(count), dateAttribute);
                        dates.add(date);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parse error", e);
        }
        return dates;
    }

    public List getSubscriptions() {
        this.clearResultMetaInformation();
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "inbox/subs?");
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList subItems = document.getElementsByTagName("sub");
                if (subItems != null && subItems.getLength() > 0) {
                    for (int i = 0; i < subItems.getLength(); ++i) {
                        Node subItem = subItems.item(i);
                        String tag = subItem.getAttributes().getNamedItem("tag").getNodeValue();
                        String user = subItem.getAttributes().getNamedItem("user").getNodeValue();
                        Subscription subscription = new Subscription(tag, user);
                        subscriptions.add(subscription);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parse error", e);
        }
        return subscriptions;
    }

    public List getBundles() {
        this.clearResultMetaInformation();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "tags/bundles/all?");
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList bundleItems = document.getElementsByTagName("bundle");
                if (bundleItems != null && bundleItems.getLength() > 0) {
                    for (int i = 0; i < bundleItems.getLength(); ++i) {
                        Node bundleItem = bundleItems.item(i);
                        String name = bundleItem.getAttributes().getNamedItem("name").getNodeValue();
                        String tags = bundleItem.getAttributes().getNamedItem("tags").getNodeValue();
                        Bundle bundle = new Bundle(name, tags);
                        bundles.add(bundle);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parse error", e);
        }
        return bundles;
    }

    public boolean addBundle(String bundleName, String tags) {
        this.clearResultMetaInformation();
        boolean addBundleResult = false;
        StringBuffer result = new StringBuffer();
        PostMethod post = new PostMethod(this.apiEndpoint + "tags/bundles/set?");
        post.setDoAuthentication(true);
        if (DeliciousUtils.checkNullOrBlank(bundleName)) {
            return false;
        }
        if (DeliciousUtils.checkNullOrBlank(tags)) {
            return false;
        }
        NameValuePair bundleNameParam = new NameValuePair("bundle", bundleName);
        NameValuePair tagsParam = new NameValuePair("tags", tags);
        post.setQueryString(new NameValuePair[]{bundleNameParam, tagsParam});
        try {
            post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            this.httpResult = this.httpClient.executeMethod((HttpMethod)post);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (post.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                post.releaseConnection();
                if (result.indexOf("ok") != -1) {
                    addBundleResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return addBundleResult;
    }

    public boolean deleteBundle(String bundleName) {
        this.clearResultMetaInformation();
        boolean deleteBundleResult = false;
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "tags/bundles/delete?");
        get.setDoAuthentication(true);
        NameValuePair bundleNameParam = new NameValuePair("bundle", bundleName);
        get.setQueryString(new NameValuePair[]{bundleNameParam});
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                if (result.indexOf("ok") != -1) {
                    deleteBundleResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return deleteBundleResult;
    }

    public boolean subs(String user, String tag, boolean unsubscribe) {
        this.clearResultMetaInformation();
        boolean subscribeResult = false;
        StringBuffer result = new StringBuffer();
        GetMethod get = !unsubscribe ? new GetMethod(this.apiEndpoint + "inbox/sub?") : new GetMethod(this.apiEndpoint + "inbox/unsub?");
        get.setDoAuthentication(true);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        NameValuePair userParam = new NameValuePair("user", user);
        params.add(userParam);
        if (!DeliciousUtils.checkNullOrBlank(tag)) {
            NameValuePair tagParam = new NameValuePair("tag", tag);
            params.add(tagParam);
        }
        if (params.size() > 0) {
            get.setQueryString(params.toArray(new NameValuePair[params.size()]));
        }
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                if (result.indexOf("<ok />") != -1) {
                    subscribeResult = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        return subscribeResult;
    }

    public Date getLastUpdate() {
        this.clearResultMetaInformation();
        StringBuffer result = new StringBuffer();
        GetMethod get = new GetMethod(this.apiEndpoint + "posts/update?");
        get.setDoAuthentication(true);
        try {
            this.httpResult = this.httpClient.executeMethod((HttpMethod)get);
            this.checkNotAuthorized(this.httpResult);
            this.logger.debug((Object)("Result: " + this.httpResult));
            if (get.getResponseBodyAsStream() != null) {
                String input;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream(), "UTF-8"));
                while ((input = bufferedReader.readLine()) != null) {
                    result.append(input).append(DeliciousUtils.LINE_SEPARATOR);
                }
                get.releaseConnection();
                Document document = this.documentBuilder.parse(new InputSource(new StringReader(result.toString())));
                NodeList updateItems = document.getElementsByTagName("update");
                if (updateItems != null && updateItems.getLength() > 0) {
                    Node updateItem = updateItems.item(0);
                    String updateTime = updateItem.getAttributes().getNamedItem("time").getNodeValue();
                    return DeliciousUtils.getDateFromUTCString(updateTime);
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
        catch (SAXException e) {
            this.logger.error((Object)e);
            throw new DeliciousException("Response parse error", e);
        }
        return null;
    }

    protected void checkNotAuthorized(int result) {
        if (result == 401) {
            throw new DeliciousNotAuthorizedException();
        }
    }

    protected void clearResultMetaInformation() {
        this.resultMetaInformation = null;
    }

    public Object getResultMetaInformation() {
        return this.resultMetaInformation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

