/*
 * Decompiled with CFR 0.152.
 */
package del.icio.us;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DeliciousUtils {
    public static final String UTF_8 = "UTF-8";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DELICIOUS_DATE_FORMAT = "yyyy-MM-dd";
    private static final ThreadLocal UTC_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DeliciousUtils.UTC_DATE_FORMAT);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat;
        }
    };
    private static final ThreadLocal DELICIOUS_DATE_FORMAT_OBJECT = new ThreadLocal(){

        protected Object initialValue() {
            return new SimpleDateFormat(DeliciousUtils.DELICIOUS_DATE_FORMAT);
        }
    };

    public static String getUTCDate(Date date) {
        return ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).format(date);
    }

    public static String getDeliciousDate(Date date) {
        return ((SimpleDateFormat)DELICIOUS_DATE_FORMAT_OBJECT.get()).format(date);
    }

    public static Date getDateFromUTCString(String time) {
        Date result = null;
        try {
            ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
            result = ((SimpleDateFormat)UTC_DATE_FORMAT_OBJECT.get()).parse(time);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public static boolean checkNullOrBlank(String input) {
        return input == null || "".equals(input);
    }

    public static String encodeUTF8(String input) {
        return DeliciousUtils.encodeUTF8(input, false);
    }

    public static String encodeUTF8(String input, boolean keepSpaces) {
        String encodedInput;
        if (input == null) {
            return null;
        }
        try {
            encodedInput = URLEncoder.encode(input, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            return input;
        }
        if (keepSpaces) {
            encodedInput = encodedInput.replaceAll("[+]", " ");
        }
        return encodedInput;
    }

    public static String encodeURLForDelicious(String input) {
        if (input == null) {
            return null;
        }
        String encodedInput = input.replaceAll("\\?", "%3F");
        encodedInput = input.replaceAll("&", "%26");
        encodedInput = input.replaceAll("#", "%23");
        return encodedInput;
    }
}

