/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.distribution.jgroups.JGroupSerializable;
import org.jgroups.Address;
import org.jgroups.blocks.NotificationBus;

public class JGroupManager
implements NotificationBus.Consumer,
CachePeer,
CacheManagerPeerProvider {
    private static String hostname = "localhost";
    private static final Logger LOG = Logger.getLogger(JGroupManager.class.getName());
    private static HashMap properties = new HashMap();
    private NotificationBus bus;
    private CacheManager cacheManager;

    public JGroupManager(CacheManager m, String connect) {
        try {
            this.cacheManager = m;
            this.bus = new NotificationBus("EH_CACHE", connect);
            this.bus.start();
            this.bus.getChannel().setOpt(3, (Object)Boolean.FALSE);
            this.bus.setConsumer((NotificationBus.Consumer)this);
            LOG.info("GMS started. address is " + this.bus.getLocalAddress());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Serializable getCache() {
        return null;
    }

    private void handleJGroupNotification(JGroupSerializable e) {
        Cache c = this.cacheManager.getCache(e.getCacheName());
        if (c != null) {
            if (e.getEvent() == 1 && c.getQuiet(e.getKey()) != null) {
                c.remove(e.getKey(), true);
            } else if (e.getEvent() == 0) {
                c.put(new Element((Object)e.getKey(), e.getValue()), true);
            } else if (e.getEvent() == 3) {
                LOG.fine("remove all");
                c.removeAll(true);
            }
        }
    }

    public void handleNotification(Serializable arg0) {
        if (arg0 instanceof JGroupSerializable) {
            this.handleJGroupNotification((JGroupSerializable)arg0);
        } else if (arg0 instanceof List) {
            List l = (List)((Object)arg0);
            for (int i = 0; i < l.size(); ++i) {
                Object obj = l.get(i);
                if (!(obj instanceof JGroupSerializable)) continue;
                this.handleJGroupNotification((JGroupSerializable)obj);
            }
        }
    }

    public void memberJoined(Address arg0) {
        LOG.finest("joined:" + arg0);
    }

    public void memberLeft(Address arg0) {
        LOG.finest("left:" + arg0);
    }

    public List getElements(List keys) throws RemoteException {
        return null;
    }

    public String getGuid() throws RemoteException {
        return null;
    }

    public List getKeys() throws RemoteException {
        return null;
    }

    public String getName() throws RemoteException {
        return null;
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        return null;
    }

    public String getUrl() throws RemoteException {
        return null;
    }

    public String getUrlBase() throws RemoteException {
        return null;
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, RemoteException {
    }

    public boolean remove(Serializable key) throws IllegalStateException, RemoteException {
        return false;
    }

    public void removeAll() throws RemoteException, IllegalStateException {
    }

    private JGroupSerializable wrapMessage(JGroupEventMessage msg) {
        Serializable value = msg.getElement() == null ? null : msg.getElement().getValue();
        return new JGroupSerializable(msg.getEvent(), msg.getSerializableKey(), value, msg.getCacheName());
    }

    public void send(List eventMessages) throws RemoteException {
        if (eventMessages.size() == 1) {
            this.bus.sendNotification((Serializable)this.wrapMessage((JGroupEventMessage)((Object)eventMessages.get(0))));
            return;
        }
        ArrayList<JGroupSerializable> msg = new ArrayList<JGroupSerializable>();
        for (JGroupEventMessage m : eventMessages) {
            msg.add(this.wrapMessage(m));
        }
        try {
            this.bus.sendNotification(msg);
        }
        catch (Throwable t) {
            throw new RemoteException(t.getMessage());
        }
    }

    public Status getStatus() {
        if (this.bus == null) {
            return Status.STATUS_UNINITIALISED;
        }
        if (this.bus.getChannel() == null) {
            return Status.STATUS_SHUTDOWN;
        }
        return Status.STATUS_ALIVE;
    }

    public void dispose() throws CacheException {
        if (this.bus != null) {
            try {
                this.bus.stop();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error occured while closing Manager:", e);
            }
        }
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public String getScheme() {
        return "JGroups";
    }

    public void init() {
    }

    public List listRemoteCachePeers(Ehcache cache) throws CacheException {
        ArrayList<JGroupManager> a = new ArrayList<JGroupManager>();
        a.add(this);
        return a;
    }

    public void registerPeer(String rmiUrl) {
    }

    public void unregisterPeer(String rmiUrl) {
    }
}

