/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.RemoteCacheException;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.distribution.jgroups.JGroupManager;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsBootstrapCacheLoader
implements BootstrapCacheLoader {
    private static final int ONE_SECOND = 1000;
    private static final Logger LOG = Logger.getLogger(JGroupsBootstrapCacheLoader.class.getName());
    private static final int WAIT_FOR_RESPONSE = 3000;
    protected boolean asynchronous;
    protected int maximumChunkSizeBytes;

    public JGroupsBootstrapCacheLoader(boolean asynchronous, int maximumChunkSize) {
        this.asynchronous = asynchronous;
        this.maximumChunkSizeBytes = maximumChunkSize;
    }

    public void load(Ehcache cache) throws RemoteCacheException {
        if (this.asynchronous) {
            BootstrapThread bootstrapThread = new BootstrapThread(cache);
            bootstrapThread.start();
        } else {
            this.doLoad(cache);
        }
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void doLoad(Ehcache cache) throws RemoteCacheException {
        List<IpAddress> addresses;
        JGroupManager jGroupManager = null;
        List cachePeers = this.acquireCachePeers(cache);
        if (cachePeers == null || cachePeers.size() == 0) {
            LOG.log(Level.INFO, "Empty list of cache peers for cache " + cache.getName() + ". No cache peer to bootstrap from.");
            return;
        }
        jGroupManager = (JGroupManager)cachePeers.get(0);
        IpAddress localAddress = (IpAddress)jGroupManager.getBusLocalAddress();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "(" + cache.getName() + ") localAddress: " + localAddress);
        }
        if ((addresses = this.buildCachePeerAddressList(cache, jGroupManager, localAddress)) == null || addresses.size() == 0) {
            LOG.log(Level.INFO, "This is the first node to start: no cache bootstrap for " + cache.getName());
            return;
        }
        IpAddress address = null;
        Random random = new Random();
        while (addresses.size() > 0 && (address == null || cache.getSize() == 0)) {
            int randomPeerNumber = random.nextInt(addresses.size());
            address = addresses.get(randomPeerNumber);
            addresses.remove(randomPeerNumber);
            JGroupEventMessage event = new JGroupEventMessage(10, (Serializable)localAddress, null, cache, cache.getName());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "contact " + address + " to boot cache " + cache.getName());
            }
            ArrayList<JGroupEventMessage> events = new ArrayList<JGroupEventMessage>();
            events.add(event);
            try {
                jGroupManager.send((Address)address, events);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.SEVERE, "InterruptedException", e);
                }
            }
            catch (RemoteException e1) {
                LOG.log(Level.SEVERE, "error calling " + address, e1);
            }
        }
        if (cache.getSize() == 0) {
            LOG.log(Level.WARNING, "Cache failed to bootstrap from its peers: " + cache.getName());
        } else {
            LOG.log(Level.INFO, "Bootstrap for cache " + cache.getName() + " has loaded " + cache.getSize() + " elements");
        }
    }

    private List<IpAddress> buildCachePeerAddressList(Ehcache cache, JGroupManager jGroupManager, IpAddress localAddress) {
        List members = jGroupManager.getBusMembership();
        ArrayList<IpAddress> addresses = new ArrayList<IpAddress>();
        for (int i = 0; i < members.size(); ++i) {
            IpAddress member = (IpAddress)members.get(i);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "(" + cache.getName() + ") member " + i + ": " + member.getIpAddress() + (member.equals((Object)localAddress) ? " ***" : ""));
            }
            if (member.equals((Object)localAddress)) continue;
            addresses.add(member);
        }
        return addresses;
    }

    protected List acquireCachePeers(Ehcache cache) {
        long timeForClusterToForm = 0L;
        CacheManagerPeerProvider cacheManagerPeerProvider = cache.getCacheManager().getCacheManagerPeerProvider("JGroups");
        if (cacheManagerPeerProvider != null) {
            timeForClusterToForm = cacheManagerPeerProvider.getTimeForClusterToForm();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Attempting to acquire cache peers for cache " + cache.getName() + " to bootstrap from. Will wait up to " + timeForClusterToForm + "ms for cache to join cluster.");
        }
        List cachePeers = null;
        int i = 0;
        while ((long)i <= timeForClusterToForm) {
            cachePeers = this.listRemoteCachePeers(cache);
            LOG.log(Level.INFO, "waiting...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, "doLoad for " + cache.getName() + " interrupted.");
            }
            i += 1000;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "cache peers: " + cachePeers.size());
        }
        return cachePeers;
    }

    protected void fetchAndPutElements(Ehcache cache, List requestChunk, CachePeer cachePeer) throws RemoteException {
        List receivedChunk = cachePeer.getElements(requestChunk);
        for (int i = 0; i < receivedChunk.size(); ++i) {
            Element element = (Element)receivedChunk.get(i);
            if (element == null) continue;
            cache.put(element, true);
        }
    }

    protected List listRemoteCachePeers(Ehcache cache) {
        CacheManagerPeerProvider provider = cache.getCacheManager().getCacheManagerPeerProvider("JGroups");
        if (provider == null) {
            return null;
        }
        return provider.listRemoteCachePeers(cache);
    }

    public int getMaximumChunkSizeBytes() {
        return this.maximumChunkSizeBytes;
    }

    public Object clone() throws CloneNotSupportedException {
        return new JGroupsBootstrapCacheLoader(this.asynchronous, this.maximumChunkSizeBytes);
    }

    private final class BootstrapThread
    extends Thread {
        private Ehcache cache;

        public BootstrapThread(Ehcache cache) {
            super("Bootstrap Thread for cache " + cache.getName());
            this.cache = cache;
            this.setDaemon(true);
            this.setPriority(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                JGroupsBootstrapCacheLoader.this.doLoad(this.cache);
            }
            catch (RemoteCacheException e) {
                LOG.log(Level.WARNING, "Error asynchronously performing bootstrap. The cause was: " + e.getMessage(), e);
            }
            finally {
                this.cache = null;
            }
        }
    }
}

