/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.openjpa.datacache;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;

public class EhCacheQueryCache
extends AbstractQueryCache
implements QueryCache {
    protected boolean useDefaultForUnnamedCaches = true;
    protected String cacheName = "openjpa-querycache";
    protected ReentrantLock writeLock = new ReentrantLock();

    protected void clearInternal() {
        this.getOrCreateCache(this.cacheName).removeAll();
    }

    protected QueryResult getInternal(QueryKey qk) {
        Ehcache cache = this.getOrCreateCache(this.cacheName);
        Element result = cache.get((Serializable)qk);
        if (result == null) {
            return null;
        }
        return (QueryResult)result.getValue();
    }

    protected Collection keySet() {
        Ehcache cache = this.getOrCreateCache(this.cacheName);
        return cache.getKeys();
    }

    protected boolean pinInternal(QueryKey qk) {
        return false;
    }

    protected QueryResult putInternal(QueryKey qk, QueryResult oids) {
        Ehcache cache = this.getOrCreateCache(this.cacheName);
        Element element = new Element((Serializable)qk, (Serializable)oids);
        cache.put(element);
        return oids;
    }

    protected QueryResult removeInternal(QueryKey qk) {
        Ehcache cache = this.getOrCreateCache(this.cacheName);
        QueryResult queryResult = this.getInternal(qk);
        cache.remove((Serializable)qk);
        return queryResult;
    }

    protected boolean unpinInternal(QueryKey qk) {
        return false;
    }

    public void writeLock() {
        this.writeLock.lock();
    }

    public void writeUnlock() {
        this.writeLock.unlock();
    }

    protected synchronized Ehcache getOrCreateCache(String name) {
        CacheManager cacheManager = CacheManager.getInstance();
        Ehcache ehCache = cacheManager.getEhcache(name);
        if (ehCache == null) {
            cacheManager.addCache(name);
            ehCache = cacheManager.getEhcache(name);
        }
        return ehCache;
    }
}

