/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import org.terracotta.agent.loader.ByteArrayReadOnlyFile;
import org.terracotta.agent.loader.JarManager;
import org.terracotta.agent.loader.Util;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.zip.Zip32InputArchive;

public class Jar {
    private static final long NOT_INITIALIZED = -1L;
    private final URL source;
    private final JarManager jarManager;
    private final ProtectionDomain pd;
    private long lastAccess = -1L;
    private Zip32InputArchive archive;
    private byte[] contents;

    Jar(URL source, JarManager jarManager) {
        this.source = source;
        this.jarManager = jarManager;
        CodeSource cs = new CodeSource(source, new Certificate[0]);
        this.pd = new ProtectionDomain(cs, new AllPermission().newPermissionCollection());
    }

    public URL getSource() {
        return this.source;
    }

    synchronized boolean isDeflated() {
        return this.archive == null && this.contents == null;
    }

    synchronized void deflateIfIdle(long idle) {
        if (this.lastAccess == -1L || this.archive == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastAccess > idle) {
            try {
                this.archive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.contents = null;
            this.archive = null;
        }
    }

    ProtectionDomain getProtectionDomain() {
        return this.pd;
    }

    public synchronized boolean hasResource(String res) throws IOException {
        this.touch();
        return this.archive.getArchiveEntry(res) != null;
    }

    private void touch() throws IOException {
        this.lastAccess = System.currentTimeMillis();
        this.inflateIfNeeded();
    }

    public synchronized byte[] lookup(String resource) throws IOException {
        this.touch();
        InputStream in = this.archive.getInputStream(resource);
        if (in == null) {
            return null;
        }
        return Util.extract(in);
    }

    public synchronized byte[] contents() throws IOException {
        this.touch();
        return this.contents;
    }

    private void inflateIfNeeded() throws IOException {
        if (this.archive == null) {
            String extForm = this.source.toExternalForm();
            if (extForm.startsWith("jar:jar:")) {
                int nesting = Jar.getNumJarSeparators(extForm);
                if (nesting > 2) {
                    throw new IOException("Cannot handle more than 3 levels of nested jar lookups");
                }
                if (nesting <= 0) {
                    throw new MalformedURLException("No '!/' found in URL beginning with 'jar:'");
                }
                extForm = extForm.substring("jar:".length());
                String secondJarUrl = extForm.substring(0, extForm.lastIndexOf("!/"));
                String resourceInSecondJar = extForm.substring(extForm.lastIndexOf("!/") + "!/".length());
                if (resourceInSecondJar.startsWith("/")) {
                    resourceInSecondJar = resourceInSecondJar.substring(1);
                }
                Jar secondJar = this.jarManager.getOrCreate(secondJarUrl, new URL(secondJarUrl));
                this.contents = secondJar.lookup(resourceInSecondJar);
            } else {
                this.contents = Util.extract(this.source.openStream());
            }
            this.archive = new Zip32InputArchive(new ByteArrayReadOnlyFile(this.contents), "UTF-8", false, false);
            this.jarManager.jarOpened(this);
        }
    }

    private static int getNumJarSeparators(String str) {
        int rv = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch != '!' || i >= length - 1 || str.charAt(i + 1) != '/') continue;
            ++rv;
        }
        return rv;
    }

    public String toString() {
        return this.source.toExternalForm();
    }
}

