/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.job;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeParser {
    private static Map daysOfWeek = new HashMap();
    private static final Log logger = LogFactory.getLog((Class)TimeParser.class);
    private static Map months = new HashMap();
    private static Map periods = new HashMap();
    private Locale locale;
    private TimeZone timeZone;

    public TimeParser() {
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
    }

    public TimeParser(Locale locale, TimeZone timeZone) {
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public String getKillTime(String time) throws ParseException {
        if (time.toLowerCase().trim().equals("now")) {
            return "000000";
        }
        long killTime = this.parse(time).getTime() - System.currentTimeMillis();
        long days = (killTime /= 1000L) / 86400L;
        long hours = (killTime %= 86400L) / 3600L;
        long minutes = (killTime %= 3600L) / 60L;
        String dayS = days < 10L ? "0" + days : "" + days;
        String hourS = hours < 10L ? "0" + hours : "" + hours;
        String minS = minutes < 10L ? "0" + minutes : "" + minutes;
        return dayS + hourS + minS;
    }

    public String getSendTime(String time) throws ParseException {
        if (time.trim().toLowerCase().equals("now")) {
            return "now";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
        return format.format(this.parse(time));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Date parse(String str) throws ParseException {
        try {
            String time;
            String string = str.toLowerCase().trim();
            Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
            cal.setTimeInMillis(System.currentTimeMillis());
            StringTokenizer tokenizer = new StringTokenizer(string);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parsing String " + string));
                logger.debug((Object)("Current Time is " + cal.getTime()));
            }
            if ((time = tokenizer.nextToken()).equals("now")) {
                if (!tokenizer.nextToken().equals("+")) throw new ParseException("Parse error now must be followed by '+'");
                try {
                    int n;
                    String number = tokenizer.nextToken();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("N = " + number));
                    }
                    if ((n = Integer.parseInt(number)) < 0) {
                        throw new NumberFormatException();
                    }
                    String period = tokenizer.nextToken();
                    if (periods.get(period) == null) {
                        throw new ParseException("period has to be minute(s), hour(s), day(s), week(s) or month(s)");
                    }
                    cal.setLenient(true);
                    cal.add((Integer)periods.get(period), n);
                    if (!logger.isDebugEnabled()) return cal.getTime();
                    logger.debug((Object)("Parsing finished, date is " + cal.getTime()));
                    return cal.getTime();
                }
                catch (NumberFormatException e) {
                    throw new ParseException("N must be a positive numeric value");
                }
            }
            SimpleDateFormat format = new SimpleDateFormat("HH:mm");
            boolean isAmPm = false;
            if (tokenizer.hasMoreTokens()) {
                String amPm = tokenizer.nextToken();
                if (amPm.equals("am") || amPm.equals("pm")) {
                    format = new SimpleDateFormat("KK:mm");
                    isAmPm = true;
                }
                try {
                    Calendar d = Calendar.getInstance();
                    d.setTime(format.parse(time));
                    cal.set(11, d.get(11));
                    cal.set(12, d.get(12));
                }
                catch (java.text.ParseException e) {
                    throw new ParseException("Time has to be hh:mm [AM|PM]");
                }
                if (isAmPm) {
                    if (amPm.equals("pm")) {
                        cal.add(10, 12);
                    }
                    if (!tokenizer.hasMoreTokens()) return cal.getTime();
                    amPm = tokenizer.nextToken();
                }
                if (daysOfWeek.get(amPm) != null) {
                    cal.set(7, (Integer)daysOfWeek.get(amPm));
                } else {
                    if (months.get(amPm) == null) throw new ParseException("Value has to be a valid month or day of week");
                    cal.set(2, (Integer)months.get(amPm));
                    try {
                        cal.setLenient(false);
                        cal.set(5, Integer.parseInt(tokenizer.nextToken()));
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException("day of month has to be a valid numeric value");
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new ParseException("day value has to be within mont boundaries");
                    }
                }
            } else {
                try {
                    Calendar d = Calendar.getInstance();
                    d.setTime(format.parse(time));
                    cal.set(11, d.get(11));
                    cal.set(12, d.get(12));
                }
                catch (java.text.ParseException e) {
                    throw new ParseException("Time has to be hh:mm [AM|PM]");
                }
            }
            if (!logger.isDebugEnabled()) return cal.getTime();
            logger.debug((Object)("Returning Date " + cal.getTime()));
            return cal.getTime();
        }
        catch (NoSuchElementException e) {
            throw new ParseException("String to parse not complete");
        }
    }

    static {
        periods.put("second", new Integer(13));
        periods.put("seconds", new Integer(13));
        periods.put("minute", new Integer(12));
        periods.put("minutes", new Integer(12));
        periods.put("hour", new Integer(10));
        periods.put("hours", new Integer(10));
        periods.put("day", new Integer(6));
        periods.put("days", new Integer(6));
        periods.put("week", new Integer(3));
        periods.put("weeks", new Integer(3));
        periods.put("month", new Integer(2));
        periods.put("months", new Integer(2));
        months.put("jan", new Integer(0));
        months.put("january", new Integer(0));
        months.put("feb", new Integer(1));
        months.put("february", new Integer(1));
        months.put("mar", new Integer(2));
        months.put("march", new Integer(2));
        months.put("apr", new Integer(3));
        months.put("april", new Integer(3));
        months.put("may", new Integer(4));
        months.put("jun", new Integer(5));
        months.put("june", new Integer(5));
        months.put("jul", new Integer(6));
        months.put("july", new Integer(6));
        months.put("aug", new Integer(7));
        months.put("august", new Integer(7));
        months.put("sep", new Integer(8));
        months.put("september", new Integer(8));
        months.put("oct", new Integer(9));
        months.put("october", new Integer(9));
        months.put("nov", new Integer(10));
        months.put("november", new Integer(10));
        months.put("dec", new Integer(11));
        months.put("december", new Integer(11));
        daysOfWeek.put("mon", new Integer(2));
        daysOfWeek.put("monday", new Integer(2));
        daysOfWeek.put("tue", new Integer(3));
        daysOfWeek.put("tuesday", new Integer(3));
        daysOfWeek.put("wed", new Integer(4));
        daysOfWeek.put("wednesday", new Integer(4));
        daysOfWeek.put("thu", new Integer(5));
        daysOfWeek.put("thursday", new Integer(5));
        daysOfWeek.put("fri", new Integer(6));
        daysOfWeek.put("friday", new Integer(6));
        daysOfWeek.put("sat", new Integer(7));
        daysOfWeek.put("saturday", new Integer(7));
        daysOfWeek.put("sun", new Integer(1));
        daysOfWeek.put("sunday", new Integer(1));
    }

    public class ParseException
    extends Exception {
        ParseException() {
        }

        ParseException(String message) {
            super(message);
        }

        ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        ParseException(Throwable cause) {
            super(cause);
        }
    }
}

