/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.AsciiOutputStream;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.Putter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivePutter
extends Putter {
    private static final Log log = LogFactory.getLog((Class)ActivePutter.class);
    private InetAddress address;
    private int port;
    private ServerSocket server = new ServerSocket(0);
    private int timeout = 30000;

    public ActivePutter(InputStream in) throws IOException {
        this.port = this.server.getLocalPort();
        this.address = this.server.getInetAddress();
        this.istream = in;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Socket sock;
        boolean signalClosure;
        block41: {
            block38: {
                signalClosure = false;
                sock = null;
                OutputStream ostream = null;
                long amount = 0L;
                int buffer_size = 0;
                byte[] buffer = new byte[1024];
                this.server.setSoTimeout(this.timeout);
                if (this.cancelled) {
                    throw new InterruptedIOException("Transfer cancelled");
                }
                sock = this.server.accept();
                this.signalConnectionOpened(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
                this.signalTransferStarted();
                try {
                    int len;
                    switch (this.type) {
                        case 'A': {
                            ostream = new AsciiOutputStream(sock.getOutputStream());
                            break;
                        }
                        default: {
                            ostream = sock.getOutputStream();
                        }
                    }
                    switch (this.mode) {
                        case 'Z': {
                            ostream = new DeflaterOutputStream(ostream);
                            break;
                        }
                    }
                    while ((len = this.istream.read(buffer)) != -1) {
                        ostream.write(buffer, 0, len);
                        amount += (long)len;
                        if ((buffer_size += len) >= 1024) {
                            buffer_size %= 1024;
                            this.signalTransfered(amount);
                        }
                        ActivePutter.yield();
                    }
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    log.debug((Object)"Closing inputstream");
                    if (ostream != null) {
                        ostream.close();
                    }
                    if (!sock.isClosed()) {
                        try {
                            log.debug((Object)"Setting socket to 0 lingering");
                            sock.setSoLinger(true, 0);
                            sock.close();
                        }
                        catch (SocketException e2) {
                            // empty catch block
                        }
                    }
                    this.signalTransferCompleted();
                    throw throwable;
                }
                log.debug((Object)"Closing inputstream");
                if (ostream != null) {
                    ostream.close();
                }
                if (!sock.isClosed()) {
                    try {
                        log.debug((Object)"Setting socket to 0 lingering");
                        sock.setSoLinger(true, 0);
                        sock.close();
                    }
                    catch (SocketException e2) {
                        // empty catch block
                    }
                }
                this.signalTransferCompleted();
                {
                    break block38;
                    catch (InterruptedIOException iioe) {
                        if (!this.cancelled) {
                            log.error((Object)iioe.getMessage(), (Throwable)iioe);
                        }
                        Object var10_12 = null;
                        log.debug((Object)"Closing inputstream");
                        if (ostream != null) {
                            ostream.close();
                        }
                        if (!sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                sock.setSoLinger(true, 0);
                                sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                        break block38;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        Object var10_13 = null;
                        log.debug((Object)"Closing inputstream");
                        if (ostream != null) {
                            ostream.close();
                        }
                        if (!sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                sock.setSoLinger(true, 0);
                                sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                    }
                }
            }
            Object var13_20 = null;
            try {
                log.debug((Object)"Closing server socket");
                this.server.close();
            }
            catch (IOException ex) {}
            break block41;
            {
                catch (Exception ee) {
                    this.signalConnectionFailed(ee);
                    log.error((Object)ee.getMessage(), (Throwable)ee);
                    Object var13_21 = null;
                    try {
                        log.debug((Object)"Closing server socket");
                        this.server.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_22 = null;
                try {
                    log.debug((Object)"Closing server socket");
                    this.server.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (signalClosure && sock != null) {
            this.signalConnectionClosed(new ConnectionEvent(sock.getInetAddress(), sock.getPort()));
        }
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }
}

