/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.hylafax.job.ReceiveEvent;
import gnu.hylafax.job.ReceiveListener;
import gnu.hylafax.job.SendEvent;
import gnu.hylafax.job.SendListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailListener
implements SendListener,
ReceiveListener {
    static final SimpleDateFormat rfc822df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
    static final String KEY_TO = "notifier.to";
    static final String KEY_FROM = "notifier.from";
    private Properties properties = new Properties(System.getProperties());
    private static final Log log = LogFactory.getLog((Class)MailListener.class);

    public void onSendEvent(SendEvent event) {
    }

    public void onReceiveEvent(ReceiveEvent event) {
        String cid = null;
        Date now = new Date();
        String subject = "Facsimile received";
        if (event.getCidName() != null && !"".equals(event.getCidName())) {
            cid = event.getCidName();
        } else if (event.getCidNumber() != null && !"".equals(event.getCidNumber())) {
            cid = event.getCidNumber();
        }
        try {
            String body;
            File f = new File(event.getFilename());
            if (!f.exists()) {
                f = new File("log" + File.separator + "c" + event.getCommunicationIdentifier());
                subject = "Facsimile failed";
                body = "A facsimile failed to be received at " + now + "\n\n" + "See the attached log file for session details.\n";
            } else {
                body = "The attached facsimile was received " + now + "\n";
            }
            if (event.getMessage() != null && !"".equals(event.getMessage())) {
                body = body + "The server's message is:\n\n\t" + event.getMessage();
            }
            if (cid != null) {
                subject = subject + " from " + cid;
            }
            Session s = Session.getDefaultInstance((Properties)this.properties);
            MimeMessage msg = new MimeMessage(s);
            msg.addRecipients(Message.RecipientType.TO, this.properties.getProperty(KEY_TO));
            msg.setSubject(subject);
            msg.addHeader("From", this.properties.getProperty(KEY_FROM));
            msg.addHeader("Date", rfc822df.format(now));
            msg.addHeader("X-MailListener", "$Id: MailListener.java,v 1.5 2007/05/07 18:26:53 sjardine Exp $");
            MimeBodyPart part0 = new MimeBodyPart();
            part0.setText(body);
            FileDataSource fds = new FileDataSource(f);
            fds.setFileTypeMap((FileTypeMap)new MimetypesFileTypeMap());
            DataHandler fdh = new DataHandler((DataSource)fds);
            MimeBodyPart part1 = new MimeBodyPart();
            part1.setDataHandler(fdh);
            part1.setDisposition("inline");
            part1.setFileName(f.getName());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part0);
            mp.addBodyPart((BodyPart)part1);
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

