/*
 * Decompiled with CFR 0.152.
 */
package gnu.hylafax.util;

import gnu.hylafax.job.ReceiveEvent;
import gnu.hylafax.job.ReceiveListener;
import gnu.hylafax.job.SendEvent;
import gnu.hylafax.job.SendListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleListener
implements SendListener,
ReceiveListener {
    private static final Log log = LogFactory.getLog((Class)SampleListener.class);
    public static final String KEY_DBUSER = "notifier.db.user";
    public static final String KEY_DBPASSWORD = "notifier.db.password";
    public static final String KEY_DBDRIVER = "notifier.db.driver";
    public static final String KEY_DBURI = "notifier.db.uri";
    String DB_USER = System.getProperties().getProperty("notifier.db.user");
    String DB_PASSWORD = System.getProperties().getProperty("notifier.db.password");
    String DB_URI = System.getProperties().getProperty("notifier.db.uri");
    String DB_CLASS = System.getProperties().getProperty("notifier.db.driver");

    public void onSendEvent(SendEvent event) {
        try {
            Class.forName(this.DB_CLASS);
            Connection connection = DriverManager.getConnection(this.DB_URI, this.DB_USER, this.DB_PASSWORD);
            String sql = "insert into send (reason,filename,jobid,jobtime,next) values (?,?,?,?,?)";
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, event.getReason());
            stmt.setString(2, event.getFilename());
            stmt.setLong(3, event.getJobId());
            stmt.setLong(4, event.getElapsedTime());
            stmt.setString(5, event.getNextAttempt());
            stmt.execute();
            stmt.close();
            connection.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onReceiveEvent(ReceiveEvent event) {
        try {
            Class.forName(this.DB_CLASS);
            Connection connection = DriverManager.getConnection(this.DB_URI, this.DB_USER, this.DB_PASSWORD);
            String sql = "insert into receive (filename,modem,commid,message,cidnumber,cidname) values (?,?,?,?,?,?)";
            PreparedStatement stmt = connection.prepareStatement(sql);
            stmt.setString(1, event.getFilename());
            stmt.setString(2, event.getModem());
            stmt.setString(3, event.getCommunicationIdentifier());
            stmt.setString(4, event.getMessage());
            stmt.setString(5, event.getCidNumber());
            stmt.setString(6, event.getCidName());
            stmt.execute();
            stmt.close();
            connection.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

